/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;

public abstract class StatementProxy
implements Statement {
    protected final IHikariConnectionProxy connection;
    protected final Statement delegate;
    private boolean isClosed;

    protected StatementProxy(IHikariConnectionProxy connection, Statement statement) {
        this.connection = connection;
        this.delegate = statement;
    }

    protected final SQLException checkException(SQLException e) {
        return this.connection.checkException(e);
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connection.untrackStatement(this);
        try {
            this.delegate.close();
        }
        catch (SQLException e) {
            throw this.connection.checkException(e);
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped statement is not an instance of " + iface);
    }
}

