/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.HikariPool;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariMBeanElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariMBeanElf.class);

    private HikariMBeanElf() {
    }

    public static void registerMBeans(HikariConfig configuration, HikariPool pool) {
        if (!configuration.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (!mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.registerMBean(configuration, poolConfigName);
                mBeanServer.registerMBean(pool, poolName);
            } else {
                LOGGER.error("You cannot use the same pool name for separate pool instances.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register management beans.", (Throwable)e);
        }
    }

    public static void unregisterMBeans(HikariConfig configuration, HikariPool pool) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.unregisterMBean(poolConfigName);
                mBeanServer.unregisterMBean(poolName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to unregister management beans.", (Throwable)e);
        }
    }

    static {
        new HikariMBeanElf();
    }
}

