/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics;

import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodaHaleShim {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodaHaleShim.class);

    private CodaHaleShim() {
    }

    public static void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrShimCodahale() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            CodaHaleShim.class.getClassLoader().loadClass("com.codahale.metrics.MetricRegistry");
        }
        catch (ClassNotFoundException e) {
            ClassPool classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            try {
                CtClass targetCt = classPool.makeClass("com.codahale.metrics.MetricRegistry");
                targetCt.setModifiers(17);
                CtConstructor constructorCt = new CtConstructor(null, targetCt);
                constructorCt.setModifiers(1);
                constructorCt.setBody("{ throw new RuntimeException(\"HikariCP Codahale shim says: Codahale metrics library is required but was not found in the classpath\"); }");
                targetCt.addConstructor(constructorCt);
                targetCt.toClass(classPool.getClassLoader(), this.getClass().getProtectionDomain());
            }
            catch (CannotCompileException cce) {
                LOGGER.error("Cannot generate CodaHale metrics shim", (Throwable)cce);
                throw new RuntimeException(cce);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    static {
        CodaHaleShim codaHaleShim = new CodaHaleShim();
        codaHaleShim.loadOrShimCodahale();
    }
}

