/*
 * Decompiled with CFR 0.152.
 */
package com.yumi.android.sdk.ads.adapter.admob;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.yumi.android.sdk.ads.adapter.admob.AdMobUtil;
import com.yumi.android.sdk.ads.beans.YumiProviderBean;
import com.yumi.android.sdk.ads.publish.adapter.YumiCustomerBannerAdapter;
import com.yumi.android.sdk.ads.utils.ZplayDebug;

public class AdmobBannerAdapter
extends YumiCustomerBannerAdapter {
    private static final String TAG = "AdmobBannerAdapter";
    private AdView adView;
    private AdListener adListener;
    private float cx = -99.0f;
    private float cy = -99.0f;

    protected AdmobBannerAdapter(Activity activity, YumiProviderBean provider) {
        super(activity, provider);
    }

    public void onActivityPause() {
        if (this.adView != null) {
            this.adView.pause();
        }
    }

    public void onActivityResume() {
        if (this.adView != null) {
            this.adView.resume();
        }
    }

    protected final void callOnActivityDestroy() {
        if (this.adView != null) {
            this.adView.destroy();
        }
    }

    protected void onPrepareBannerLayer() {
        ZplayDebug.d((String)TAG, (String)"admob request new banner", (boolean)true);
        this.adView = new AdView((Context)this.getActivity());
        this.adView.setAdSize(this.calculateBannerSize());
        this.adView.setAdUnitId(this.getProvider().getKey1());
        this.adView.setAdListener(this.adListener);
        AdRequest req = new AdRequest.Builder().build();
        this.adView.loadAd(req);
    }

    protected void init() {
        ZplayDebug.i((String)TAG, (String)("unitId : " + this.getProvider().getKey1()), (boolean)true);
        this.createAdListener();
    }

    private void createAdListener() {
        this.adListener = new AdListener(){

            public void onAdClosed() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner closed", (boolean)true);
                AdmobBannerAdapter.this.layerClosed();
                super.onAdClosed();
            }

            public void onAdOpened() {
                super.onAdOpened();
            }

            public void onAdLeftApplication() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner clicked", (boolean)true);
                AdmobBannerAdapter.this.layerClicked(AdmobBannerAdapter.this.cx, AdmobBannerAdapter.this.cy);
                super.onAdLeftApplication();
            }

            public void onAdLoaded() {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)"admob banner preapred", (boolean)true);
                AdmobBannerAdapter.this.layerPrepared((View)AdmobBannerAdapter.this.adView, true);
                super.onAdLoaded();
            }

            public void onAdFailedToLoad(int errorCode) {
                ZplayDebug.d((String)AdmobBannerAdapter.TAG, (String)("admob banner failed " + errorCode), (boolean)true);
                AdmobBannerAdapter.this.layerPreparedFailed(AdMobUtil.recodeError(errorCode));
                super.onAdFailedToLoad(errorCode);
            }
        };
    }

    private AdSize calculateBannerSize() {
        if (this.isMatchWindowWidth && AdmobBannerAdapter.isPortrait((Context)this.getActivity())) {
            return AdSize.SMART_BANNER;
        }
        switch (this.bannerSize) {
            case BANNER_SIZE_SMART: {
                return AdSize.SMART_BANNER;
            }
            case BANNER_SIZE_728X90: {
                return AdSize.LEADERBOARD;
            }
        }
        return AdSize.BANNER;
    }

    private static boolean isPortrait(Context context) {
        try {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            return dm.widthPixels <= dm.heightPixels;
        }
        catch (Exception e) {
            return false;
        }
    }
}

