/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.httpclient;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogHttpClientInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TLogHttpClientInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            request.addHeader("tlogTraceId", traceId);
            request.addHeader("tlogSpanId", SpanIdGenerator.generateNextSpanId());
            request.addHeader("preIvkApp", appName);
            request.addHeader("preIvkHost", LocalhostUtil.getHostName());
            request.addHeader("preIp", LocalhostUtil.getHostIp());
        } else {
            log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

