/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.feign.filter;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.utils.LocalhostUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TLogFeignFilter
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TLogFeignFilter.class);
    @Value(value="${spring.application.name}")
    private String appName;

    public void apply(RequestTemplate requestTemplate) {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            requestTemplate.header("tlogTraceId", new String[]{traceId});
            requestTemplate.header("tlogSpanId", new String[]{SpanIdGenerator.generateNextSpanId()});
            requestTemplate.header("preIvkApp", new String[]{this.appName});
            requestTemplate.header("preIvkHost", new String[]{LocalhostUtil.getHostName()});
            requestTemplate.header("preIp", new String[]{LocalhostUtil.getHostIp()});
        } else {
            log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

