/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.aop;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.yomahub.tlog.core.annotation.TLogAspect;
import com.yomahub.tlog.core.context.AspectLogContext;
import com.yomahub.tlog.core.convert.AspectLogConvert;
import com.yomahub.tlog.exception.TLogCustomLabelExpressionException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Aspect
public class AspectLogAop {
    private static final Logger log = LoggerFactory.getLogger(AspectLogAop.class);
    private ExpressRunner expressRunner = new ExpressRunner();

    @Pointcut(value="@annotation(com.yomahub.tlog.core.annotation.TLogAspect)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        boolean isAspectLogConvert;
        Object[] args = jp.getArgs();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        String[] parameterNames = signature.getParameterNames();
        HashMap paramNameValueMap = MapUtil.newHashMap();
        for (int i = 0; i < parameterNames.length; ++i) {
            paramNameValueMap.put(parameterNames[i], args[i]);
        }
        TLogAspect tlogAspect = method.getAnnotation(TLogAspect.class);
        String[] aspectExpressions = tlogAspect.value();
        String str = tlogAspect.str();
        String pattern = tlogAspect.pattern();
        String joint = tlogAspect.joint();
        Class<? extends AspectLogConvert> convertClazz = tlogAspect.convert();
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isNotBlank((CharSequence)str)) {
            sb.append(str);
            sb.append(joint);
        }
        if (isAspectLogConvert = convertClazz.equals(AspectLogConvert.class) ? false : AspectLogConvert.class.isAssignableFrom(convertClazz)) {
            AspectLogConvert convert = convertClazz.newInstance();
            try {
                sb.append(convert.convert(args));
                sb.append(joint);
            }
            catch (Throwable t) {
                log.error("[AspectLog]some errors happens in AspectLog's convert", t);
            }
        }
        for (String aspectExpression : aspectExpressions) {
            String aspLogValueItem = this.getExpressionValue(aspectExpression, paramNameValueMap);
            if (!StringUtils.isNotBlank((CharSequence)aspLogValueItem)) continue;
            sb.append(StrUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{aspectExpression, aspLogValueItem}));
            sb.append(joint);
        }
        String aspLogValue = sb.toString();
        if (StringUtils.isNotBlank((CharSequence)aspLogValue)) {
            aspLogValue = aspLogValue.substring(0, aspLogValue.length() - joint.length());
            aspLogValue = StrUtil.format((CharSequence)pattern, (Object[])new Object[]{aspLogValue});
            String currentLabel = AspectLogContext.getLogValue();
            MDC.put((String)"tl", (String)(currentLabel + " " + aspLogValue));
            AspectLogContext.putLogValue(currentLabel + " " + aspLogValue);
        }
        return jp.proceed();
    }

    private String getExpressionValue(String expression, Map<String, Object> map) {
        ArrayList errorList = new ArrayList();
        try {
            InstructionSet instructionSet = this.expressRunner.getInstructionSetFromLocalCache("map." + expression);
            DefaultContext context = new DefaultContext();
            context.put((Object)"map", map);
            Object value = this.expressRunner.execute(instructionSet, (IExpressContext)context, errorList, false, false);
            if (ObjectUtil.isNull((Object)value)) {
                return null;
            }
            if (ObjectUtil.isBasicType((Object)value)) {
                return value.toString();
            }
            return JSON.toJSONString((Object)value);
        }
        catch (Throwable t) {
            for (String scriptErrorMsg : errorList) {
                log.error("\n{}", (Object)scriptErrorMsg);
            }
            log.error(t.getMessage(), t);
            throw new TLogCustomLabelExpressionException(t.getMessage());
        }
    }
}

