/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;

public final class SelectiveJavaEscaper {
    public static final CharSequenceTranslator ESCAPE_JAVA_SELECTIVE;

    private SelectiveJavaEscaper() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringWriter writer = new StringWriter((int)((double)input.length() * 1.5));
        try {
            ESCAPE_JAVA_SELECTIVE.translate((CharSequence)input, (Writer)writer);
        }
        catch (IOException ioe) {
            throw new AssertionError("IOException thrown by StringWriter", ioe);
        }
        return writer.toString();
    }

    public static void main(String[] args) {
        String originalString = "\u4f60\u597d\uff0c\"\u4e16\u754c\"\uff01\n\tEnd.";
        System.out.println("\u539f\u59cb\u5b57\u7b26\u4e32: " + originalString);
        String escapedString = SelectiveJavaEscaper.escape(originalString);
        System.out.println("\u9009\u62e9\u6027\u8f6c\u4e49\u540e: " + escapedString);
    }

    static {
        HashMap<String, String> basicEscapeMap = new HashMap<String, String>();
        basicEscapeMap.put("\"", "\\\"");
        basicEscapeMap.put("\\", "\\\\");
        LookupTranslator basicEscaper = new LookupTranslator(Collections.unmodifiableMap(basicEscapeMap));
        HashMap<String, String> controlCharsMap = new HashMap<String, String>();
        controlCharsMap.put("\n", "\\n");
        controlCharsMap.put("\t", "\\t");
        controlCharsMap.put("\r", "\\r");
        controlCharsMap.put("\f", "\\f");
        controlCharsMap.put("\b", "\\b");
        LookupTranslator controlCharsEscaper = new LookupTranslator(Collections.unmodifiableMap(controlCharsMap));
        ESCAPE_JAVA_SELECTIVE = new AggregateTranslator(new CharSequenceTranslator[]{controlCharsEscaper, basicEscaper});
    }
}

