/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.ParallelStrategyEnum;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.parallel.strategy.ParallelStrategyExecutor;
import com.yomahub.liteflow.flow.parallel.strategy.ParallelStrategyHelper;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class WhenCondition
extends Condition {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private boolean ignoreError = false;
    private String group = "default";
    private ParallelStrategyEnum parallelStrategy;
    private Set<String> specifyIdSet;
    private String threadExecutorClass;
    private Integer maxWaitTime;
    private TimeUnit maxWaitTimeUnit;
    private Double percentage;

    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        this.executeAsyncCondition(slotIndex);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_WHEN;
    }

    private void executeAsyncCondition(Integer slotIndex) throws Exception {
        ParallelStrategyExecutor parallelStrategyExecutor = ParallelStrategyHelper.loadInstance().buildParallelExecutor(this.getParallelStrategy());
        parallelStrategyExecutor.execute(this, slotIndex);
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ParallelStrategyEnum getParallelStrategy() {
        return this.parallelStrategy;
    }

    public void setParallelStrategy(ParallelStrategyEnum parallelStrategy) {
        this.parallelStrategy = parallelStrategy;
    }

    public Set<String> getSpecifyIdSet() {
        return this.specifyIdSet;
    }

    public void setSpecifyIdSet(Set<String> specifyIdSet) {
        this.specifyIdSet = specifyIdSet;
    }

    public String getThreadExecutorClass() {
        return this.threadExecutorClass;
    }

    public void setThreadExecutorClass(String threadExecutorClass) {
        ExecutorHelper.loadInstance().buildWhenExecutor(threadExecutorClass);
        this.threadExecutorClass = threadExecutorClass;
    }

    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(Integer maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public TimeUnit getMaxWaitTimeUnit() {
        return this.maxWaitTimeUnit;
    }

    public void setMaxWaitTimeUnit(TimeUnit maxWaitTimeUnit) {
        this.maxWaitTimeUnit = maxWaitTimeUnit;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }
}

