/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.ExecuteableTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Condition
implements Executable {
    private String id;
    private String tag;
    private final Map<String, List<Executable>> executableGroup = new HashMap<String, List<Executable>>();
    private String currChainId;

    @Override
    public void execute(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        try {
            slot.pushCondition(this);
            this.executeCondition(slotIndex);
        }
        catch (ChainEndException e) {
            throw e;
        }
        catch (Exception e) {
            slot.setException(e);
            throw e;
        }
        finally {
            slot.popCondition();
        }
    }

    public abstract void executeCondition(Integer var1) throws Exception;

    @Override
    public ExecuteableTypeEnum getExecuteType() {
        return ExecuteableTypeEnum.CONDITION;
    }

    public List<Executable> getExecutableList() {
        return this.getExecutableList("DEFAULT_KEY");
    }

    public List<Executable> getExecutableList(String groupKey) {
        List<Executable> executableList = this.executableGroup.get(groupKey);
        if (CollUtil.isEmpty(executableList)) {
            executableList = new ArrayList<Executable>();
        }
        return executableList;
    }

    public Executable getExecutableOne(String groupKey) {
        List<Executable> list = this.getExecutableList(groupKey);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public List<Node> getAllNodeInCondition() {
        List<Executable> executableList = this.executableGroup.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        ArrayList<Node> resultList = new ArrayList<Node>();
        executableList.forEach(executable -> {
            if (executable instanceof Condition) {
                resultList.addAll(((Condition)executable).getAllNodeInCondition());
            } else if (executable instanceof Chain) {
                resultList.addAll(((Chain)executable).getConditionList().stream().flatMap(condition -> condition.getAllNodeInCondition().stream()).collect(Collectors.toList()));
            } else if (executable instanceof Node) {
                resultList.add((Node)executable);
            }
        });
        return resultList;
    }

    public void setExecutableList(List<Executable> executableList) {
        this.executableGroup.put("DEFAULT_KEY", executableList);
    }

    public void addExecutable(Executable executable) {
        this.addExecutable("DEFAULT_KEY", executable);
    }

    public void addExecutable(String groupKey, Executable executable) {
        if (ObjectUtil.isNull((Object)executable)) {
            return;
        }
        List<Executable> executableList = this.executableGroup.get(groupKey);
        if (CollUtil.isEmpty(executableList)) {
            this.executableGroup.put(groupKey, ListUtil.toList((Object[])new Executable[]{executable}));
        } else {
            this.executableGroup.get(groupKey).add(executable);
        }
    }

    public abstract ConditionTypeEnum getConditionType();

    @Override
    public String getId() {
        if (StrUtil.isBlank((CharSequence)this.id)) {
            return StrUtil.format((CharSequence)"condition-{}", (Object[])new Object[]{this.getConditionType().getName()});
        }
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Deprecated
    public String getCurrChainName() {
        return this.currChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    @Override
    public void setCurrChainId(String currChainId) {
        this.currChainId = currChainId;
    }

    public Map<String, List<Executable>> getExecutableGroup() {
        return this.executableGroup;
    }
}

