/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor.util;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    private Messager mMessager;

    public Logger(Messager messager) {
        this.mMessager = messager;
    }

    public void i(CharSequence info) {
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, info);
        }
    }

    public void e(CharSequence error) {
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "An exception is encountered, " + error);
        }
    }

    public void e(Throwable error) {
        if (null != error) {
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "An exception is encountered, " + error.getMessage() + "\n" + this.formatStackTrace(error.getStackTrace()));
        }
    }

    public void w(CharSequence warning) {
        if (StringUtils.isNotEmpty((CharSequence)warning)) {
            this.mMessager.printMessage(Diagnostic.Kind.WARNING, warning);
        }
    }

    private String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("    at ").append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

