/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.BaseVariant;
import com.yanzhenjie.andserver.plugin.AppInfoGenerator;
import com.yanzhenjie.andserver.plugin.util.Log;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;

public class AndServerPlugin
implements Plugin<Project> {
    public void apply(@Nonnull Project project) {
        Log.inject(project);
        project.getPlugins().all(it -> {
            if (it instanceof AppPlugin) {
                AppExtension extension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
                this.configGenerator(project, (DomainObjectSet<? extends BaseVariant>)extension.getApplicationVariants());
            } else if (it instanceof LibraryPlugin) {
                LibraryExtension extension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
                this.configGenerator(project, (DomainObjectSet<? extends BaseVariant>)extension.getLibraryVariants());
            } else if (it instanceof FeaturePlugin) {
                FeatureExtension extension = (FeatureExtension)project.getExtensions().getByType(FeatureExtension.class);
                this.configGenerator(project, (DomainObjectSet<? extends BaseVariant>)extension.getFeatureVariants());
            }
        });
    }

    private void configGenerator(Project project, DomainObjectSet<? extends BaseVariant> variants) {
        variants.all(it -> {
            this.configTask((BaseVariant)it);
            File outputDir = new File(project.getBuildDir(), "generated/source/andServer/" + it.getDirName());
            String taskName = String.format("generate%sAppInfo", AndServerPlugin.capitalize(it.getName()));
            Task generate = project.getTasks().create(taskName, AppInfoGenerator.class, generator -> {
                generator.setOutputDir(outputDir);
                String appId = it.getApplicationId();
                generator.setAppId(appId);
                String packageName = String.format("%s.andserver.plugin.generator", appId);
                generator.setPackageName(packageName);
            });
            it.registerJavaGeneratingTask(generate, new File[]{outputDir});
        });
    }

    private void configTask(BaseVariant variant) {
        Action action = task -> {
            String filename = String.format("%s.andserver", variant.getApplicationId());
            File file = new File(((Directory)variant.getMergeAssets().getOutputDir().get()).getAsFile(), filename);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    FileUtils.write((File)file, (CharSequence)filename);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        variant.getMergeAssets().doLast(action);
    }

    public static String capitalize(String text) {
        if (text != null && text.length() > 0) {
            char[] chars = text.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return text;
    }
}

