/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.multipart;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.multipart.MultipartFile;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class StandardMultipartFile
implements MultipartFile,
Serializable {
    private final FileItem fileItem;
    private final long size;

    public StandardMultipartFile(FileItem fileItem) {
        this.fileItem = fileItem;
        this.size = fileItem.getSize();
    }

    public final FileItem getFileItem() {
        return this.fileItem;
    }

    @Override
    @NonNull
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    @Nullable
    public String getFilename() {
        int pos;
        String filename = this.fileItem.getName();
        if (filename == null) {
            return "";
        }
        int unixSep = filename.lastIndexOf("/");
        int winSep = filename.lastIndexOf("\\");
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            return filename.substring(pos + 1);
        }
        return filename;
    }

    @Override
    @NonNull
    public MediaType getContentType() {
        MediaType mediaType;
        String mimeType = this.fileItem.getContentType();
        try {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        catch (Exception e) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return mediaType;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte[] getBytes() {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has been moved - cannot be read again.");
        }
        byte[] bytes = this.fileItem.get();
        return bytes != null ? bytes : new byte[]{};
    }

    @Override
    @NonNull
    public InputStream getStream() throws IOException {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has been moved - cannot be read again.");
        }
        InputStream inputStream = this.fileItem.getInputStream();
        return inputStream != null ? inputStream : IOUtils.createEmptyInput();
    }

    @Override
    public void transferTo(@NonNull File dest) throws IOException, IllegalStateException {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has already been moved - cannot be transferred again.");
        }
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted.");
        }
        try {
            this.fileItem.write(dest);
        }
        catch (FileUploadException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("File transfer failed", ex);
        }
    }

    protected boolean isAvailable() {
        if (this.fileItem.isInMemory()) {
            return true;
        }
        if (this.fileItem instanceof DiskFileItem) {
            return ((DiskFileItem)this.fileItem).getStoreLocation().exists();
        }
        return this.fileItem.getSize() == this.size;
    }
}

