/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.cookie;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.cookie.Cookie;
import com.yanzhenjie.andserver.http.cookie.CookieProcessor;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.httpcore.Header;

public class StandardCookieProcessor
implements CookieProcessor {
    private static final String COOKIE_DATE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> COOKIE_DATE_FORMAT;
    private static final String ANCIENT_DATE;
    private static final BitSet DOMAIN_VALID;

    @Override
    @NonNull
    public List<Cookie> parseCookieHeader(@Nullable Header[] headers) {
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (Header header : headers) {
            String name = header.getName();
            if (!"Cookie".equalsIgnoreCase(name)) continue;
            String headerValue = header.getValue();
            this.parserCookieValue(headerValue, cookieList);
        }
        return cookieList;
    }

    private void parserCookieValue(String headerValue, List<Cookie> cookieList) {
        StringTokenizer tokenizer = new StringTokenizer(headerValue, ";");
        while (tokenizer.hasMoreTokens()) {
            String segment = tokenizer.nextToken();
            int split = segment.indexOf("=");
            int valueIndex = split + 1;
            if (split <= 0 || valueIndex >= segment.length()) continue;
            String name = segment.substring(0, split).trim();
            String value = segment.substring(valueIndex, segment.length()).trim();
            cookieList.add(new Cookie(name, value));
        }
    }

    @Override
    @NonNull
    public String generateHeader(@NonNull Cookie cookie) {
        String path;
        String domain;
        int maxAge;
        StringBuffer header = new StringBuffer();
        header.append(cookie.getName());
        header.append('=');
        String value = cookie.getValue();
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.validateCookieValue(value);
            header.append(value);
        }
        if ((maxAge = cookie.getMaxAge()) > -1) {
            header.append("; Max-Age=");
            header.append(maxAge);
            header.append("; Expires=");
            if (maxAge == 0) {
                header.append(ANCIENT_DATE);
            } else {
                Date date = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
                COOKIE_DATE_FORMAT.get().format(date, header, new FieldPosition(0));
            }
        }
        if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
            this.validateDomain(domain);
            header.append("; Domain=");
            header.append(domain);
        }
        if ((path = cookie.getPath()) != null && path.length() > 0) {
            this.validatePath(path);
            header.append("; Path=");
            header.append(path);
        }
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        return header.toString();
    }

    private void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            String message = String.format("The cookie's value [%1$s] is invalid.", value);
            throw new IllegalArgumentException(message);
        }
    }

    private void validateDomain(String domain) {
        int prev = -1;
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            prev = cur;
            cur = chars[i];
            if (!DOMAIN_VALID.get(cur)) {
                String message = String.format("The cookie's domain [%1$s] is invalid.", domain);
                throw new IllegalArgumentException(message);
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                String message = String.format("The cookie's domain [%1$s] is invalid.", domain);
                throw new IllegalArgumentException(message);
            }
            if (prev != 45 || cur != 46) continue;
            String message = String.format("The cookie's domain [%1$s] is invalid.", domain);
            throw new IllegalArgumentException(message);
        }
        if (cur == 46 || cur == 45) {
            String message = String.format("The cookie's domain [%1$s] is invalid.", domain);
            throw new IllegalArgumentException(message);
        }
    }

    private void validatePath(String path) {
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            String message = String.format("The cookie's path [%1$s] is invalid.", path);
            throw new IllegalArgumentException(message);
        }
    }

    static {
        int c;
        COOKIE_DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(StandardCookieProcessor.COOKIE_DATE_PATTERN, Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df;
            }
        };
        ANCIENT_DATE = COOKIE_DATE_FORMAT.get().format(new Date(10000L));
        DOMAIN_VALID = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            DOMAIN_VALID.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            DOMAIN_VALID.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            DOMAIN_VALID.set(c);
        }
        DOMAIN_VALID.set(46);
        DOMAIN_VALID.set(45);
    }
}

