/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.DispatcherHandler;
import com.yanzhenjie.andserver.http.AcceptLanguage;
import com.yanzhenjie.andserver.http.HttpContext;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.RequestBody;
import com.yanzhenjie.andserver.http.RequestDispatcher;
import com.yanzhenjie.andserver.http.Uri;
import com.yanzhenjie.andserver.http.cookie.Cookie;
import com.yanzhenjie.andserver.http.cookie.CookieProcessor;
import com.yanzhenjie.andserver.http.cookie.StandardCookieProcessor;
import com.yanzhenjie.andserver.http.session.Session;
import com.yanzhenjie.andserver.http.session.SessionManager;
import com.yanzhenjie.andserver.util.HttpDateFormat;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.LinkedMultiValueMap;
import com.yanzhenjie.andserver.util.MediaType;
import com.yanzhenjie.andserver.util.MultiValueMap;
import com.yanzhenjie.andserver.util.UrlCoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.Charsets;
import org.apache.httpcore.Header;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpEntityEnclosingRequest;
import org.apache.httpcore.RequestLine;

public class StandardRequest
implements HttpRequest {
    private static final CookieProcessor COOKIE_PROCESSOR = new StandardCookieProcessor();
    private org.apache.httpcore.HttpRequest mRequest;
    private HttpContext mContext;
    private DispatcherHandler mHandler;
    private RequestLine mRequestLine;
    private SessionManager mSessionManager;
    private Uri mUri;
    private boolean isParsedUri;
    private MultiValueMap<String, String> mQuery;
    private boolean isParsedQuery;
    private List<MediaType> mAccepts;
    private boolean isParsedAccept;
    private List<Locale> mLocales;
    private boolean isParsedLocale;
    private MultiValueMap<String, String> mParameter;
    private boolean isParsedParameter;

    public StandardRequest(org.apache.httpcore.HttpRequest request, HttpContext context, DispatcherHandler handler, SessionManager sessionManager) {
        this.mRequest = request;
        this.mContext = context;
        this.mHandler = handler;
        this.mRequestLine = request.getRequestLine();
        this.mSessionManager = sessionManager;
    }

    @Override
    public String getLocalName() {
        return this.mRequest.getLocalName();
    }

    @Override
    public String getLocalAddr() {
        return this.mRequest.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        return this.mRequest.getLocalPort();
    }

    @Override
    public String getRemoteAddr() {
        return this.mRequest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return this.mRequest.getRemoteHost();
    }

    @Override
    public int getRemotePort() {
        return this.mRequest.getRemotePort();
    }

    @Override
    @NonNull
    public HttpMethod getMethod() {
        return HttpMethod.reverse(this.mRequestLine.getMethod());
    }

    @Override
    @NonNull
    public String getURI() {
        this.parseUri();
        return this.mUri.toString();
    }

    private void parseUri() {
        if (this.isParsedUri) {
            return;
        }
        String requestLine = this.mRequestLine.getUri();
        if (TextUtils.isEmpty((CharSequence)requestLine)) {
            requestLine = "/";
        }
        String uri = "scheme://host:ip" + requestLine;
        this.mUri = Uri.newBuilder(uri).build();
        this.isParsedUri = true;
    }

    public void setPath(String path) {
        this.parseUri();
        this.mUri = this.mUri.builder().setPath(path).build();
    }

    @Override
    @NonNull
    public String getPath() {
        this.parseUri();
        return this.mUri.getPath();
    }

    @Override
    @NonNull
    public List<String> getQueryNames() {
        this.parseQuery();
        return new LinkedList<String>(this.mQuery.keySet());
    }

    @Override
    @Nullable
    public String getQuery(@NonNull String name) {
        this.parseQuery();
        return this.mQuery.getFirst(name);
    }

    @Override
    @NonNull
    public List<String> getQueries(@NonNull String name) {
        this.parseQuery();
        List values = (List)this.mQuery.get(name);
        return values == null || values.isEmpty() ? Collections.emptyList() : values;
    }

    @Override
    @NonNull
    public MultiValueMap<String, String> getQuery() {
        this.parseQuery();
        return this.mQuery;
    }

    private void parseQuery() {
        if (this.isParsedQuery) {
            return;
        }
        this.parseUri();
        this.mQuery = this.mUri.getParams();
        this.isParsedQuery = true;
    }

    @Override
    @NonNull
    public List<String> getHeaderNames() {
        Header[] headers = this.mRequest.getAllHeaders();
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Header header : headers) {
            nameList.add(header.getName());
        }
        return nameList;
    }

    @Override
    @Nullable
    public String getHeader(@NonNull String name) {
        Header header = this.mRequest.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    @NonNull
    public List<String> getHeaders(@NonNull String name) {
        Header[] headers = this.mRequest.getHeaders(name);
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> valueList = new ArrayList<String>();
        for (Header header : headers) {
            valueList.add(header.getValue());
        }
        return valueList;
    }

    @Override
    public long getDateHeader(@NonNull String name) {
        Header header = this.mRequest.getFirstHeader(name);
        if (header == null) {
            return -1L;
        }
        String value = header.getValue();
        long date = HttpDateFormat.parseDate(value);
        if (date == -1L) {
            String message = String.format("The %s cannot be converted to date.", value);
            throw new IllegalStateException(message);
        }
        return date;
    }

    @Override
    public int getIntHeader(@NonNull String name) {
        Header header = this.mRequest.getFirstHeader(name);
        if (header == null) {
            return -1;
        }
        try {
            return Integer.parseInt(header.getValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public MediaType getAccept() {
        List<MediaType> mediaTypes = this.getAccepts();
        return mediaTypes.isEmpty() ? null : mediaTypes.get(0);
    }

    @Override
    @NonNull
    public List<MediaType> getAccepts() {
        this.parseAccept();
        return this.mAccepts;
    }

    private void parseAccept() {
        if (this.isParsedAccept) {
            return;
        }
        this.mAccepts = new ArrayList<MediaType>();
        Header[] headers = this.mRequest.getHeaders("Accept");
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                List<MediaType> mediaTypes = MediaType.parseMediaTypes(header.getValue());
                this.mAccepts.addAll(mediaTypes);
            }
        }
        if (this.mAccepts.isEmpty()) {
            this.mAccepts.add(MediaType.ALL);
        }
        this.isParsedAccept = true;
    }

    @Override
    @NonNull
    public Locale getAcceptLanguage() {
        return this.getAcceptLanguages().get(0);
    }

    @Override
    @NonNull
    public List<Locale> getAcceptLanguages() {
        this.parseLocale();
        return this.mLocales;
    }

    private void parseLocale() {
        if (this.isParsedLocale) {
            return;
        }
        this.mLocales = new ArrayList<Locale>();
        Header[] headers = this.mRequest.getHeaders("Accept-Language");
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                List<AcceptLanguage> acceptLanguages = AcceptLanguage.parse(header.getValue());
                for (AcceptLanguage acceptLanguage : acceptLanguages) {
                    this.mLocales.add(acceptLanguage.getLocale());
                }
            }
        }
        if (this.mLocales.isEmpty()) {
            this.mLocales.add(Locale.getDefault());
        }
        this.isParsedLocale = true;
    }

    @Override
    @Nullable
    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public Cookie getCookie(@NonNull String name) {
        List<Cookie> cookies = this.getCookies();
        if (cookies.isEmpty()) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equalsIgnoreCase(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    @NonNull
    public List<Cookie> getCookies() {
        return COOKIE_PROCESSOR.parseCookieHeader(this.mRequest.getHeaders("Cookie"));
    }

    @Override
    public long getContentLength() {
        String contentLength = this.getHeader("Content-Length");
        if (TextUtils.isEmpty((CharSequence)contentLength)) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    @Nullable
    public MediaType getContentType() {
        String contentType = this.getHeader("Content-Type");
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            return null;
        }
        return MediaType.valueOf(contentType);
    }

    @Override
    @NonNull
    public List<String> getParameterNames() {
        this.parseParameter();
        LinkedList<String> paramNames = new LinkedList<String>(this.mParameter.keySet());
        List<String> names = this.getQueryNames();
        if (!names.isEmpty()) {
            paramNames.addAll(names);
        }
        return paramNames;
    }

    @Override
    @Nullable
    public String getParameter(@NonNull String name) {
        this.parseParameter();
        String value = this.mParameter.getFirst(name);
        return TextUtils.isEmpty((CharSequence)value) ? this.getQuery(name) : value;
    }

    @Override
    @NonNull
    public List<String> getParameters(@NonNull String name) {
        this.parseParameter();
        List values = (List)this.mParameter.get(name);
        if (values == null || values.isEmpty()) {
            return this.getQueries(name);
        }
        return values;
    }

    @Override
    @NonNull
    public MultiValueMap<String, String> getParameter() {
        this.parseParameter();
        return this.mParameter.isEmpty() ? this.getQuery() : this.mParameter;
    }

    private void parseParameter() {
        if (this.isParsedParameter) {
            return;
        }
        if (!this.getMethod().allowBody()) {
            this.mParameter = new LinkedMultiValueMap<String, String>();
            return;
        }
        MediaType mediaType = this.getContentType();
        if (MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType)) {
            try {
                RequestBody body = this.getBody();
                String bodyString = body == null ? "" : body.string();
                this.mParameter = StandardRequest.parseParameters(bodyString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mParameter == null) {
            this.mParameter = new LinkedMultiValueMap<String, String>();
        }
        this.isParsedParameter = true;
    }

    @Override
    @Nullable
    public RequestBody getBody() {
        if (this.getMethod().allowBody()) {
            if (this.mRequest instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)this.mRequest;
                HttpEntity entity = request.getEntity();
                if (entity == null) {
                    return null;
                }
                return new EntityToBody(entity);
            }
            return null;
        }
        throw new UnsupportedOperationException("This method does not allow body.");
    }

    @Override
    @NonNull
    public Session getValidSession() {
        Session session = this.getSession();
        if (session == null) {
            session = this.mSessionManager.createSession();
        } else if (session.isValid()) {
            session = this.mSessionManager.createSession();
        }
        this.setAttribute("http.request.Session", session);
        return session;
    }

    @Override
    public Session getSession() {
        Object objSession = this.getAttribute("http.request.Session");
        if (objSession instanceof Session) {
            return (Session)objSession;
        }
        List<Cookie> cookies = this.getCookies();
        if (cookies.isEmpty()) {
            return null;
        }
        String sessionId = null;
        for (Cookie cookie : cookies) {
            if (!"ASESSIONID".equalsIgnoreCase(cookie.getName())) continue;
            sessionId = cookie.getValue();
            break;
        }
        if (TextUtils.isEmpty(sessionId)) {
            return null;
        }
        Session session = null;
        try {
            session = this.mSessionManager.findSession(sessionId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return session;
    }

    @Override
    public String changeSessionId() {
        Session session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("No session associated with this request.");
        }
        this.mSessionManager.changeSessionId(session);
        return session.getId();
    }

    @Override
    public boolean isSessionValid() {
        Session session = this.getSession();
        return session != null && session.isValid();
    }

    @Override
    @Nullable
    public RequestDispatcher getRequestDispatcher(@NonNull String path) {
        return this.mHandler.getRequestDispatcher(this, path);
    }

    @Override
    public HttpContext getContext() {
        return this.mContext;
    }

    @Override
    @Nullable
    public Object getAttribute(@NonNull String id) {
        return this.mContext.getAttribute(id);
    }

    @Override
    public void setAttribute(@NonNull String id, @Nullable Object obj) {
        this.mContext.setAttribute(id, obj);
    }

    @Override
    @Nullable
    public Object removeAttribute(@NonNull String id) {
        return this.mContext.removeAttribute(id);
    }

    @NonNull
    private static MultiValueMap<String, String> parseParameters(@NonNull String input) {
        LinkedMultiValueMap<String, String> parameters = new LinkedMultiValueMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(input, "&");
        while (tokenizer.hasMoreElements()) {
            String element = tokenizer.nextToken();
            int end = element.indexOf("=");
            if (end <= 0 || end >= element.length() - 1) continue;
            String key = element.substring(0, end);
            String value = element.substring(end + 1);
            parameters.add(key, UrlCoder.urlDecode(value, Charsets.toCharset((String)"utf-8")));
        }
        return parameters;
    }

    private static class EntityToBody
    implements RequestBody {
        private HttpEntity mEntity;

        private EntityToBody(HttpEntity entity) {
            this.mEntity = entity;
        }

        @Override
        public String contentEncoding() {
            Header encoding = this.mEntity.getContentType();
            return encoding == null ? "" : encoding.getValue();
        }

        @Override
        public long length() {
            return this.mEntity.getContentLength();
        }

        @Override
        @Nullable
        public MediaType contentType() {
            Header header = this.mEntity.getContentType();
            if (header == null) {
                return null;
            }
            String contentType = header.getValue();
            return MediaType.valueOf(contentType);
        }

        @Override
        @NonNull
        public InputStream stream() throws IOException {
            InputStream stream = this.mEntity.getContent();
            if (this.contentEncoding().toLowerCase().contains("gzip")) {
                stream = new GZIPInputStream(stream);
            }
            return stream;
        }

        @Override
        @NonNull
        public String string() throws IOException {
            Charset charset;
            MediaType mimeType = this.contentType();
            Charset charset2 = charset = mimeType == null ? null : mimeType.getCharset();
            if (charset == null) {
                return IOUtils.toString(this.stream());
            }
            return IOUtils.toString(this.stream(), charset);
        }
    }
}

