/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.body;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;

public class StringBody
implements ResponseBody {
    private byte[] mBody;
    private MediaType mMediaType;

    public StringBody(String body) {
        this(body, MediaType.TEXT_PLAIN);
    }

    public StringBody(String body, MediaType mediaType) {
        Charset charset;
        if (body == null) {
            throw new IllegalArgumentException("The content cannot be null.");
        }
        this.mMediaType = mediaType;
        if (this.mMediaType == null) {
            this.mMediaType = new MediaType(MediaType.TEXT_PLAIN, Charsets.toCharset((String)"utf-8"));
        }
        if ((charset = this.mMediaType.getCharset()) == null) {
            charset = Charsets.toCharset((String)"utf-8");
        }
        this.mBody = body.getBytes(charset);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public long contentLength() {
        return this.mBody.length;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        Charset charset = this.mMediaType.getCharset();
        if (charset == null) {
            charset = Charsets.toCharset((String)"utf-8");
            return new MediaType(this.mMediaType.getType(), this.mMediaType.getSubtype(), charset);
        }
        return this.mMediaType;
    }

    @Override
    public void writeTo(@NonNull OutputStream output) throws IOException {
        IOUtils.write(output, this.mBody);
    }
}

