/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.body;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileBody
implements ResponseBody {
    private File mBody;

    public FileBody(File body) {
        if (body == null) {
            throw new IllegalArgumentException("The file cannot be null.");
        }
        this.mBody = body;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public long contentLength() {
        return this.mBody.length();
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return MediaType.getFileMediaType(this.mBody.getName());
    }

    @Override
    public void writeTo(@NonNull OutputStream output) throws IOException {
        FileInputStream is = new FileInputStream(this.mBody);
        IOUtils.write((InputStream)is, output);
        IOUtils.closeQuietly(is);
    }
}

