/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.httpclient;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.httpclient.InstrumentedConnByRoute;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public class InstrumentedClientConnManager
extends ThreadSafeClientConnManager {
    public InstrumentedClientConnManager(SchemeRegistry registry) {
        this(registry, -1L, TimeUnit.MILLISECONDS);
    }

    public InstrumentedClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    public InstrumentedClientConnManager(SchemeRegistry registry, long connTTL, TimeUnit connTTLTimeUnit) {
        super(registry, connTTL, connTTLTimeUnit);
        Metrics.newGauge(ClientConnectionManager.class, (String)"connections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return InstrumentedClientConnManager.this.getConnectionsInPool();
            }
        });
    }

    protected ConnPoolByRoute createConnectionPool(long connTTL, TimeUnit connTTLTimeUnit) {
        return new InstrumentedConnByRoute(this.connOperator, (ConnPerRoute)this.connPerRoute, 20, connTTL, connTTLTimeUnit);
    }
}

