/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.ehcache;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

public class InstrumentedEhcache
extends EhcacheDecoratorAdapter {
    private final Timer getTimer;
    private final Timer putTimer;

    public static Ehcache instrument(final Ehcache cache) {
        cache.setSampledStatisticsEnabled(true);
        cache.setStatisticsAccuracy(0);
        Metrics.newGauge(cache.getClass(), (String)"hits", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getCacheHits();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"in-memory-hits", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getInMemoryHits();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"off-heap-hits", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getOffHeapHits();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"on-disk-hits", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getOnDiskHits();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"misses", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getCacheMisses();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"in-memory-misses", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getInMemoryMisses();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"off-heap-misses", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getOffHeapMisses();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"on-disk-misses", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getOnDiskMisses();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"objects", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getObjectCount();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"in-memory-objects", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getMemoryStoreObjectCount();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"off-heap-objects", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getOffHeapStoreObjectCount();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"on-disk-objects", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getDiskStoreObjectCount();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"mean-get-time", (String)cache.getName(), (Gauge)new Gauge<Float>(){

            public Float value() {
                return Float.valueOf(cache.getStatistics().getAverageGetTime());
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"mean-search-time", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getAverageSearchTime();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"eviction-count", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getEvictionCount();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"searches-per-second", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getSearchesPerSecond();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"writer-queue-size", (String)cache.getName(), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.getStatistics().getWriterQueueSize();
            }
        });
        Metrics.newGauge(cache.getClass(), (String)"accuracy", (String)cache.getName(), (Gauge)new Gauge<String>(){

            public String value() {
                return cache.getStatistics().getStatisticsAccuracyDescription();
            }
        });
        return new InstrumentedEhcache(cache);
    }

    private InstrumentedEhcache(Ehcache cache) {
        super(cache);
        this.getTimer = Metrics.newTimer(cache.getClass(), (String)"get", (String)cache.getName(), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.putTimer = Metrics.newTimer(cache.getClass(), (String)"put", (String)cache.getName(), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws IllegalStateException, CacheException {
        long start = System.nanoTime();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            this.getTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        long start = System.nanoTime();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            this.getTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        long start = System.nanoTime();
        try {
            this.underlyingCache.put(element);
        }
        finally {
            this.putTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        long start = System.nanoTime();
        try {
            this.underlyingCache.put(element, doNotNotifyCacheReplicators);
        }
        finally {
            this.putTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        long start = System.nanoTime();
        try {
            Element element2 = this.underlyingCache.putIfAbsent(element);
            return element2;
        }
        finally {
            this.putTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

