/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.yalantis.ucrop.callback.BitmapCropCallback;
import java.io.File;
import java.io.IOException;

public class BitmapCropTask
extends AsyncTask<Void, Void, Throwable> {
    private Bitmap mViewBitmap;
    private final RectF mCropRect;
    private final RectF mCurrentImageRect;
    private float mCurrentScale;
    private float mCurrentAngle;
    private final int mMaxResultImageSizeX;
    private final int mMaxResultImageSizeY;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final String mImageInputPath;
    private final String mImageOutputPath;
    private final BitmapCropCallback mCropCallback;

    public BitmapCropTask(@Nullable Bitmap viewBitmap, @NonNull RectF cropRect, @NonNull RectF currentImageRect, float currentScale, float currentAngle, int maxResultImageSizeX, int maxResultImageSizeY, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality, @NonNull String imageInputPath, @NonNull String imageOutputPath, @Nullable BitmapCropCallback cropCallback) {
        this.mViewBitmap = viewBitmap;
        this.mCropRect = cropRect;
        this.mCurrentImageRect = currentImageRect;
        this.mCurrentScale = currentScale;
        this.mCurrentAngle = currentAngle;
        this.mMaxResultImageSizeX = maxResultImageSizeX;
        this.mMaxResultImageSizeY = maxResultImageSizeY;
        this.mCompressFormat = compressFormat;
        this.mCompressQuality = compressQuality;
        this.mImageInputPath = imageInputPath;
        this.mImageOutputPath = imageOutputPath;
        this.mCropCallback = cropCallback;
    }

    @Nullable
    protected Throwable doInBackground(Void ... params) {
        if (this.mViewBitmap == null || this.mViewBitmap.isRecycled()) {
            return new NullPointerException("ViewBitmap is null or already recycled");
        }
        if (this.mCurrentImageRect.isEmpty()) {
            return new NullPointerException("CurrentImageRect is empty");
        }
        float resizeScale = this.resize();
        try {
            this.crop(resizeScale);
            this.mViewBitmap.recycle();
            this.mViewBitmap = null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    private float resize() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)this.mImageInputPath, (BitmapFactory.Options)options);
        float scaleX = options.outWidth / this.mViewBitmap.getWidth();
        float scaleY = options.outHeight / this.mViewBitmap.getHeight();
        float resizeScale = Math.min(scaleX, scaleY);
        this.mCurrentScale /= resizeScale;
        resizeScale = 1.0f;
        if (this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0) {
            float cropWidth = this.mCropRect.width() / this.mCurrentScale;
            float cropHeight = this.mCropRect.height() / this.mCurrentScale;
            if (cropWidth > (float)this.mMaxResultImageSizeX || cropHeight > (float)this.mMaxResultImageSizeY) {
                scaleX = (float)this.mMaxResultImageSizeX / cropWidth;
                scaleY = (float)this.mMaxResultImageSizeY / cropHeight;
                resizeScale = Math.min(scaleX, scaleY);
                this.mCurrentScale /= resizeScale;
            }
        }
        return resizeScale;
    }

    private boolean crop(float resizeScale) throws IOException {
        int height;
        int width;
        ExifInterface originalExif = new ExifInterface(this.mImageInputPath);
        int top = Math.round((this.mCropRect.top - this.mCurrentImageRect.top) / this.mCurrentScale);
        int left = Math.round((this.mCropRect.left - this.mCurrentImageRect.left) / this.mCurrentScale);
        boolean cropped = this.cropCImg(this.mImageInputPath, this.mImageOutputPath, left, top, width = Math.round(this.mCropRect.width() / this.mCurrentScale), height = Math.round(this.mCropRect.height() / this.mCurrentScale), this.mCurrentAngle, resizeScale, this.mCompressFormat.ordinal(), this.mCompressQuality);
        if (cropped) {
            this.copyExif(originalExif, width, height);
        }
        return cropped;
    }

    public native boolean cropCImg(String var1, String var2, int var3, int var4, int var5, int var6, float var7, float var8, int var9, int var10) throws IOException, OutOfMemoryError;

    public void copyExif(ExifInterface originalExif, int width, int height) throws IOException {
        String[] attributes = new String[]{"FNumber", "DateTime", "DateTimeDigitized", "ExposureTime", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSProcessingMethod", "GPSTimeStamp", "ISOSpeedRatings", "Make", "Model", "SubSecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "WhiteBalance"};
        ExifInterface newExif = new ExifInterface(this.mImageOutputPath);
        for (String attribute : attributes) {
            String value = originalExif.getAttribute(attribute);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            newExif.setAttribute(attribute, value);
        }
        newExif.setAttribute("ImageWidth", String.valueOf(width));
        newExif.setAttribute("ImageLength", String.valueOf(height));
        newExif.setAttribute("Orientation", "0");
        newExif.saveAttributes();
    }

    protected void onPostExecute(@Nullable Throwable t) {
        if (this.mCropCallback != null) {
            if (t == null) {
                this.mCropCallback.onBitmapCropped(Uri.fromFile((File)new File(this.mImageOutputPath)));
            } else {
                this.mCropCallback.onCropFailure(t);
            }
        }
    }

    static {
        System.loadLibrary("ucrop");
    }
}

