/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.yalantis.ucrop.callback.BitmapLoadCallback;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

public class BitmapLoadTask
extends AsyncTask<Void, Void, BitmapWorkerResult> {
    private static final String TAG = "BitmapWorkerTask";
    private final Context mContext;
    private Uri mInputUri;
    private final Uri mOutputUri;
    private final int mRequiredWidth;
    private final int mRequiredHeight;
    private final BitmapLoadCallback mBitmapLoadCallback;

    public BitmapLoadTask(@NonNull Context context, @Nullable Uri inputUri, @Nullable Uri outputUri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
        this.mContext = context;
        this.mInputUri = inputUri;
        this.mOutputUri = outputUri;
        this.mRequiredWidth = requiredWidth;
        this.mRequiredHeight = requiredHeight;
        this.mBitmapLoadCallback = loadCallback;
    }

    @NonNull
    protected BitmapWorkerResult doInBackground(Void ... params) {
        ParcelFileDescriptor parcelFileDescriptor;
        if (this.mInputUri == null || this.mOutputUri == null) {
            return new BitmapWorkerResult(null, new NullPointerException("Uri cannot be null"));
        }
        if ("http".equals(this.mInputUri.getScheme()) || "https".equals(this.mInputUri.getScheme())) {
            try {
                this.downloadFile(this.mInputUri, this.mOutputUri);
            }
            catch (IOException | NullPointerException e) {
                Log.e((String)TAG, (String)"Downloading failed", (Throwable)e);
                return new BitmapWorkerResult(null, e);
            }
        }
        try {
            parcelFileDescriptor = this.mContext.getContentResolver().openFileDescriptor(this.mInputUri, "r");
        }
        catch (FileNotFoundException e) {
            return new BitmapWorkerResult(null, e);
        }
        if (parcelFileDescriptor == null) {
            return new BitmapWorkerResult(null, new NullPointerException("ParcelFileDescriptor was null for given Uri"));
        }
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            return new BitmapWorkerResult(null, new IllegalArgumentException("Bounds for bitmap could not be retrieved from Uri"));
        }
        options.inSampleSize = BitmapLoadUtils.calculateInSampleSize(options, this.mRequiredWidth, this.mRequiredHeight);
        options.inJustDecodeBounds = false;
        Bitmap decodeSampledBitmap = null;
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            try {
                decodeSampledBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
                decodeAttemptSuccess = true;
            }
            catch (OutOfMemoryError error) {
                Log.e((String)TAG, (String)"doInBackground: BitmapFactory.decodeFileDescriptor: ", (Throwable)error);
                ++options.inSampleSize;
            }
        }
        if (decodeSampledBitmap == null) {
            return new BitmapWorkerResult(null, new IllegalArgumentException("Bitmap could not be decoded from Uri"));
        }
        if (Build.VERSION.SDK_INT >= 16) {
            BitmapLoadUtils.close((Closeable)parcelFileDescriptor);
        }
        int exifOrientation = BitmapLoadUtils.getExifOrientation(this.mContext, this.mInputUri);
        int exifDegrees = BitmapLoadUtils.exifToDegrees(exifOrientation);
        int exifTranslation = BitmapLoadUtils.exifToTranslation(exifOrientation);
        Matrix matrix = new Matrix();
        if (exifDegrees != 0) {
            matrix.preRotate((float)exifDegrees);
        }
        if (exifTranslation != 1) {
            matrix.postScale((float)exifTranslation, 1.0f);
        }
        if (!matrix.isIdentity()) {
            return new BitmapWorkerResult(BitmapLoadUtils.transformBitmap(decodeSampledBitmap, matrix), null);
        }
        return new BitmapWorkerResult(decodeSampledBitmap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(@NonNull Uri inputUri, @NonNull Uri outputUri) throws NullPointerException, IOException {
        OkHttpClient client = new OkHttpClient();
        BufferedSource source = null;
        Sink sink = null;
        Response response = null;
        try {
            Request request = new Request.Builder().url(inputUri.toString()).build();
            response = client.newCall(request).execute();
            source = response.body().source();
            OutputStream outputStream = this.mContext.getContentResolver().openOutputStream(outputUri);
            if (outputStream == null) {
                throw new NullPointerException("OutputStream for given output Uri was null");
            }
            sink = Okio.sink((OutputStream)outputStream);
            source.readAll(sink);
        }
        catch (Throwable throwable) {
            BitmapLoadUtils.close(source);
            BitmapLoadUtils.close(sink);
            if (response != null) {
                BitmapLoadUtils.close((Closeable)response.body());
            }
            throw throwable;
        }
        BitmapLoadUtils.close((Closeable)source);
        BitmapLoadUtils.close((Closeable)sink);
        if (response != null) {
            BitmapLoadUtils.close((Closeable)response.body());
        }
        client.dispatcher().cancelAll();
        this.mInputUri = this.mOutputUri;
    }

    protected void onPostExecute(@NonNull BitmapWorkerResult result) {
        if (result.mBitmapWorkerException == null) {
            this.mBitmapLoadCallback.onBitmapLoaded(result.mBitmapResult);
        } else {
            this.mBitmapLoadCallback.onFailure(result.mBitmapWorkerException);
        }
    }

    public static class BitmapWorkerResult {
        Bitmap mBitmapResult;
        Exception mBitmapWorkerException;

        public BitmapWorkerResult(@Nullable Bitmap bitmapResult, @Nullable Exception bitmapWorkerException) {
            this.mBitmapResult = bitmapResult;
            this.mBitmapWorkerException = bitmapWorkerException;
        }
    }
}

