/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.util.CubicEasing;
import com.yalantis.ucrop.util.RectUtils;
import com.yalantis.ucrop.view.TransformImageView;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public abstract class CropImageView
extends TransformImageView {
    public static final float SOURCE_IMAGE_ASPECT_RATIO = 0.0f;
    private static final boolean DEFAULT_SHOW_CROP_FRAME = false;
    private static final boolean DEFAULT_SHOW_CROP_GRID = true;
    private static final int DEFAULT_CROP_GRID_ROW_COUNT = 3;
    private static final int DEFAULT_CROP_GRID_COLUMN_COUNT = 3;
    private static final int DEFAULT_IMAGE_TO_CROP_BOUNDS_ANIM_DURATION = 777;
    private static final float DEFAULT_ASPECT_RATIO = 0.0f;
    private static final float DEFAULT_MAX_SCALE_MULTIPLIER = 10.0f;
    private final RectF mCropRect = new RectF();
    private final RectF mCropViewRect = new RectF();
    private final Matrix mTempMatrix = new Matrix();
    private int mCropGridRowCount;
    private int mCropGridColumnCount;
    private float mTargetAspectRatio;
    private float[] mGridPoints = null;
    private boolean mShowCropFrame;
    private boolean mShowCropGrid;
    private Paint mDimmedPaint;
    private Paint mGridInnerLinePaint;
    private Paint mGridOuterLinePaint;
    private float mMaxScaleMultiplier;
    private Runnable mWrapCropBoundsRunnable;
    private Runnable mZoomImageToPositionRunnable = null;
    private float mMaxScale;
    private float mMinScale;
    private int mMaxResultImageSizeX = 0;
    private int mMaxResultImageSizeY = 0;
    private long mImageToWrapCropBoundsAnimDuration = 777L;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    @Nullable
    public Bitmap cropImage() throws Exception {
        Bitmap viewBitmap = this.getViewBitmap();
        RectF currentImageRect = RectUtils.trapToRect(this.mCurrentImageCorners);
        if (viewBitmap == null || currentImageRect.isEmpty() || !this.isImageWrapCropBounds()) {
            return null;
        }
        float currentScale = this.getCurrentScale();
        float currentAngle = this.getCurrentAngle();
        if (this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0) {
            float cropWidth = this.mCropRect.width() / currentScale;
            float cropHeight = this.mCropRect.height() / currentScale;
            if (cropWidth > (float)this.mMaxResultImageSizeX || cropHeight > (float)this.mMaxResultImageSizeY) {
                float scaleX = (float)this.mMaxResultImageSizeX / cropWidth;
                float scaleY = (float)this.mMaxResultImageSizeY / cropHeight;
                float resizeScale = Math.min(scaleX, scaleY);
                Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)viewBitmap, (int)((int)((float)viewBitmap.getWidth() * resizeScale)), (int)((int)((float)viewBitmap.getHeight() * resizeScale)), (boolean)false);
                viewBitmap.recycle();
                viewBitmap = resizedBitmap;
                currentScale /= resizeScale;
            }
        }
        if (currentAngle != 0.0f) {
            this.mTempMatrix.reset();
            this.mTempMatrix.setRotate(currentAngle, (float)(viewBitmap.getWidth() / 2), (float)(viewBitmap.getHeight() / 2));
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)viewBitmap, (int)0, (int)0, (int)viewBitmap.getWidth(), (int)viewBitmap.getHeight(), (Matrix)this.mTempMatrix, (boolean)true);
            viewBitmap.recycle();
            viewBitmap = rotatedBitmap;
        }
        int top = (int)((this.mCropRect.top - currentImageRect.top) / currentScale);
        int left = (int)((this.mCropRect.left - currentImageRect.left) / currentScale);
        int width = (int)(this.mCropRect.width() / currentScale);
        int height = (int)(this.mCropRect.height() / currentScale);
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)viewBitmap, (int)left, (int)top, (int)width, (int)height);
        viewBitmap.recycle();
        return croppedBitmap;
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }

    public float getMinScale() {
        return this.mMinScale;
    }

    public float getTargetAspectRatio() {
        return this.mTargetAspectRatio;
    }

    public void setTargetAspectRatio(float targetAspectRatio) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            this.mTargetAspectRatio = targetAspectRatio;
            return;
        }
        this.mTargetAspectRatio = targetAspectRatio == 0.0f ? (float)drawable2.getIntrinsicWidth() / (float)drawable2.getIntrinsicHeight() : targetAspectRatio;
        this.setupCropBounds();
        this.mGridPoints = null;
        this.postInvalidate();
    }

    public void setMaxResultImageSizeX(@IntRange(from=10L) int maxResultImageSizeX) {
        this.mMaxResultImageSizeX = maxResultImageSizeX;
    }

    public void setMaxResultImageSizeY(@IntRange(from=10L) int maxResultImageSizeY) {
        this.mMaxResultImageSizeY = maxResultImageSizeY;
    }

    public void setImageToWrapCropBoundsAnimDuration(@IntRange(from=100L) long imageToWrapCropBoundsAnimDuration) {
        if (imageToWrapCropBoundsAnimDuration <= 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative value.");
        }
        this.mImageToWrapCropBoundsAnimDuration = imageToWrapCropBoundsAnimDuration;
    }

    public void zoomOutImage(float deltaScale) {
        this.zoomOutImage(deltaScale, this.mCropRect.centerX(), this.mCropRect.centerY());
    }

    public void zoomOutImage(float scale, float centerX, float centerY) {
        if (scale >= this.getMinScale()) {
            this.postScale(scale / this.getCurrentScale(), centerX, centerY);
        }
    }

    public void zoomInImage(float deltaScale) {
        this.zoomInImage(deltaScale, this.mCropRect.centerX(), this.mCropRect.centerY());
    }

    public void zoomInImage(float scale, float centerX, float centerY) {
        if (scale <= this.getMaxScale()) {
            this.postScale(scale / this.getCurrentScale(), centerX, centerY);
        }
    }

    @Override
    public void postScale(float deltaScale, float px, float py) {
        if (deltaScale > 1.0f && this.getCurrentScale() * deltaScale <= this.getMaxScale()) {
            super.postScale(deltaScale, px, py);
        } else if (deltaScale < 1.0f && this.getCurrentScale() * deltaScale >= this.getMinScale()) {
            super.postScale(deltaScale, px, py);
        }
    }

    public void postRotate(float deltaAngle) {
        this.postRotate(deltaAngle, this.mCropRect.centerX(), this.mCropRect.centerY());
    }

    public void cancelAllAnimations() {
        this.removeCallbacks(this.mWrapCropBoundsRunnable);
        this.removeCallbacks(this.mZoomImageToPositionRunnable);
    }

    public void setImageToWrapCropBounds() {
        if (!this.isImageWrapCropBounds()) {
            float currentX = this.mCurrentImageCenter[0];
            float currentY = this.mCurrentImageCenter[1];
            float currentScale = this.getCurrentScale();
            float deltaX = this.mCropRect.centerX() - currentX;
            float deltaY = this.mCropRect.centerY() - currentY;
            float deltaScale = 0.0f;
            this.mTempMatrix.reset();
            this.mTempMatrix.setTranslate(deltaX, deltaY);
            float[] tempCurrentImageCorners = Arrays.copyOf(this.mCurrentImageCorners, this.mCurrentImageCorners.length);
            this.mTempMatrix.mapPoints(tempCurrentImageCorners);
            boolean willImageWrapCropBoundsAfterTranslate = this.isImageWrapCropBounds(tempCurrentImageCorners);
            if (!willImageWrapCropBoundsAfterTranslate) {
                RectF tempCropRect = new RectF(this.mCropRect);
                this.mTempMatrix.reset();
                this.mTempMatrix.setRotate(this.getCurrentAngle());
                this.mTempMatrix.mapRect(tempCropRect);
                float[] currentImageSides = RectUtils.getRectSidesFromCorners(this.mCurrentImageCorners);
                deltaScale = Math.max(tempCropRect.width() / currentImageSides[0], tempCropRect.height() / currentImageSides[1]);
                deltaScale = (float)((double)deltaScale * 1.01);
                deltaScale = deltaScale * currentScale - currentScale;
            }
            this.mWrapCropBoundsRunnable = new WrapCropBoundsRunnable(this, this.mImageToWrapCropBoundsAnimDuration, currentX, currentY, deltaX, deltaY, currentScale, deltaScale, willImageWrapCropBoundsAfterTranslate);
            this.post(this.mWrapCropBoundsRunnable);
        }
    }

    @Override
    protected void init(Context context, AttributeSet attrs, int defStyle) {
        super.init(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ucrop_CropImageView);
        this.processStyledAttributes(a);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDimmedLayer(canvas);
        this.drawCropGrid(canvas);
    }

    protected void drawDimmedLayer(@NonNull Canvas canvas) {
        canvas.drawRect(0.0f, this.mCropViewRect.top, this.mCropViewRect.left, this.mCropViewRect.bottom, this.mDimmedPaint);
        canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), this.mCropViewRect.top, this.mDimmedPaint);
        canvas.drawRect(this.mCropViewRect.right, this.mCropViewRect.top, (float)canvas.getWidth(), this.mCropViewRect.bottom, this.mDimmedPaint);
        canvas.drawRect(0.0f, this.mCropViewRect.bottom, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mDimmedPaint);
    }

    protected void drawCropGrid(@NonNull Canvas canvas) {
        if (this.mShowCropGrid) {
            if (this.mGridPoints == null && !this.mCropViewRect.isEmpty()) {
                int i;
                this.mGridPoints = new float[(this.mCropGridRowCount - 1) * 4 + (this.mCropGridColumnCount - 1) * 4];
                int index = 0;
                for (i = 0; i < this.mCropGridRowCount - 1; ++i) {
                    this.mGridPoints[index++] = this.mCropViewRect.left;
                    this.mGridPoints[index++] = this.mCropViewRect.height() * (((float)i + 1.0f) / (float)this.mCropGridRowCount) + this.mCropViewRect.top;
                    this.mGridPoints[index++] = this.mCropViewRect.right;
                    this.mGridPoints[index++] = this.mCropViewRect.height() * (((float)i + 1.0f) / (float)this.mCropGridRowCount) + this.mCropViewRect.top;
                }
                for (i = 0; i < this.mCropGridColumnCount - 1; ++i) {
                    this.mGridPoints[index++] = this.mCropViewRect.width() * (((float)i + 1.0f) / (float)this.mCropGridColumnCount) + this.mCropViewRect.left;
                    this.mGridPoints[index++] = this.mCropViewRect.top;
                    this.mGridPoints[index++] = this.mCropViewRect.width() * (((float)i + 1.0f) / (float)this.mCropGridColumnCount) + this.mCropViewRect.left;
                    this.mGridPoints[index++] = this.mCropViewRect.bottom;
                }
            }
            if (this.mGridPoints != null) {
                canvas.drawLines(this.mGridPoints, this.mGridInnerLinePaint);
            }
        }
        if (this.mShowCropFrame) {
            canvas.drawRect(this.mCropViewRect, this.mGridOuterLinePaint);
        }
    }

    @Override
    protected void onImageLaidOut() {
        super.onImageLaidOut();
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        float drawableWidth = drawable2.getIntrinsicWidth();
        float drawableHeight = drawable2.getIntrinsicHeight();
        if (this.mTargetAspectRatio == 0.0f) {
            this.mTargetAspectRatio = drawableWidth / drawableHeight;
        }
        this.setupCropBounds();
        this.setupInitialImagePosition(drawableWidth, drawableHeight);
        this.setImageMatrix(this.mCurrentImageMatrix);
        if (this.mTransformImageListener != null) {
            this.mTransformImageListener.onScale(this.getCurrentScale());
            this.mTransformImageListener.onRotate(this.getCurrentAngle());
        }
    }

    protected boolean isImageWrapCropBounds() {
        return this.isImageWrapCropBounds(this.mCurrentImageCorners);
    }

    protected boolean isImageWrapCropBounds(float[] imageCorners) {
        this.mTempMatrix.reset();
        this.mTempMatrix.setRotate(-this.getCurrentAngle());
        float[] unrotatedImageCorners = Arrays.copyOf(imageCorners, imageCorners.length);
        this.mTempMatrix.mapPoints(unrotatedImageCorners);
        float[] unrotatedCropBoundsCorners = RectUtils.getCornersFromRect(this.mCropRect);
        this.mTempMatrix.mapPoints(unrotatedCropBoundsCorners);
        return RectUtils.trapToRect(unrotatedImageCorners).contains(RectUtils.trapToRect(unrotatedCropBoundsCorners));
    }

    protected void zoomImageToPosition(float scale, float centerX, float centerY, long durationMs) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        float oldScale = this.getCurrentScale();
        float deltaScale = scale - oldScale;
        this.mZoomImageToPositionRunnable = new ZoomImageToPosition(this, durationMs, oldScale, deltaScale, centerX, centerY);
        this.post(this.mZoomImageToPositionRunnable);
    }

    private void setupInitialImagePosition(float drawableWidth, float drawableHeight) {
        float cropRectWidth = this.mCropRect.width();
        float cropRectHeight = this.mCropRect.height();
        float widthScale = cropRectWidth / drawableWidth;
        float heightScale = cropRectHeight / drawableHeight;
        this.mMinScale = Math.max(widthScale, heightScale);
        this.mMaxScale = this.mMinScale * this.mMaxScaleMultiplier;
        float tw = (cropRectWidth - drawableWidth * this.mMinScale) / 2.0f + this.mCropRect.left;
        float th = (cropRectHeight - drawableHeight * this.mMinScale) / 2.0f + this.mCropRect.top;
        this.mCurrentImageMatrix.reset();
        this.mCurrentImageMatrix.postScale(this.mMinScale, this.mMinScale);
        this.mCurrentImageMatrix.postTranslate(tw, th);
    }

    private void processStyledAttributes(@NonNull TypedArray a) {
        float targetAspectRatioX = Math.abs(a.getFloat(R.styleable.ucrop_CropImageView_ucrop_aspect_ratio_x, 0.0f));
        float targetAspectRatioY = Math.abs(a.getFloat(R.styleable.ucrop_CropImageView_ucrop_aspect_ratio_y, 0.0f));
        this.mTargetAspectRatio = targetAspectRatioX == 0.0f || targetAspectRatioY == 0.0f ? 0.0f : targetAspectRatioX / targetAspectRatioY;
        this.mMaxScaleMultiplier = a.getFloat(R.styleable.ucrop_CropImageView_ucrop_max_scale_multiplier, 10.0f);
        int overlayColor = a.getColor(R.styleable.ucrop_CropImageView_ucrop_overlay_color, this.getResources().getColor(R.color.ucrop_color_default_overlay));
        this.mDimmedPaint = new Paint();
        this.mDimmedPaint.setColor(overlayColor);
        this.mDimmedPaint.setStyle(Paint.Style.FILL);
        this.initCropFrameStyle(a);
        this.mShowCropFrame = a.getBoolean(R.styleable.ucrop_CropImageView_ucrop_show_frame, false);
        this.initCropGridStyle(a);
        this.mShowCropGrid = a.getBoolean(R.styleable.ucrop_CropImageView_ucrop_show_grid, true);
    }

    private void initCropFrameStyle(@NonNull TypedArray a) {
        int cropFrameStrokeSize = a.getDimensionPixelSize(R.styleable.ucrop_CropImageView_ucrop_frame_stroke_size, this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_frame_stoke_size));
        int cropFrameColor = a.getColor(R.styleable.ucrop_CropImageView_ucrop_frame_color, this.getResources().getColor(R.color.ucrop_color_default_crop_frame));
        this.mGridOuterLinePaint = new Paint(1);
        this.mGridOuterLinePaint.setStrokeWidth((float)cropFrameStrokeSize);
        this.mGridOuterLinePaint.setColor(cropFrameColor);
        this.mGridOuterLinePaint.setStyle(Paint.Style.STROKE);
    }

    private void initCropGridStyle(@NonNull TypedArray a) {
        int cropGridStrokeSize = a.getDimensionPixelSize(R.styleable.ucrop_CropImageView_ucrop_grid_stroke_size, this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_grid_stoke_size));
        int cropGridColor = a.getColor(R.styleable.ucrop_CropImageView_ucrop_grid_color, this.getResources().getColor(R.color.ucrop_color_default_crop_grid));
        this.mGridInnerLinePaint = new Paint(1);
        this.mGridInnerLinePaint.setStrokeWidth((float)cropGridStrokeSize);
        this.mGridInnerLinePaint.setColor(cropGridColor);
        this.mCropGridRowCount = a.getInt(R.styleable.ucrop_CropImageView_ucrop_grid_row_count, 3);
        this.mCropGridColumnCount = a.getInt(R.styleable.ucrop_CropImageView_ucrop_grid_column_count, 3);
    }

    private void setupCropBounds() {
        int height = (int)((float)this.mThisWidth / this.mTargetAspectRatio);
        if (height > this.mThisHeight) {
            int width = (int)((float)this.mThisHeight * this.mTargetAspectRatio);
            int halfDiff = (this.mThisWidth - width) / 2;
            this.mCropRect.set((float)halfDiff, 0.0f, (float)(width + halfDiff), (float)this.mThisHeight);
            this.mCropViewRect.set((float)(this.getPaddingLeft() + halfDiff), (float)this.getPaddingTop(), (float)(this.getPaddingLeft() + width + halfDiff), (float)(this.getPaddingTop() + this.mThisHeight));
        } else {
            int halfDiff = (this.mThisHeight - height) / 2;
            this.mCropRect.set(0.0f, (float)halfDiff, (float)this.mThisWidth, (float)(height + halfDiff));
            this.mCropViewRect.set((float)this.getPaddingLeft(), (float)(this.getPaddingTop() + halfDiff), (float)(this.getPaddingLeft() + this.mThisWidth), (float)(this.getPaddingTop() + height + halfDiff));
        }
    }

    private static class ZoomImageToPosition
    implements Runnable {
        private final WeakReference<CropImageView> mCropImageView;
        private final long mDurationMs;
        private final long mStartTime;
        private final float mOldScale;
        private final float mDeltaScale;
        private final float mDestX;
        private final float mDestY;

        public ZoomImageToPosition(CropImageView cropImageView, long durationMs, float oldScale, float deltaScale, float destX, float destY) {
            this.mCropImageView = new WeakReference<CropImageView>(cropImageView);
            this.mStartTime = System.currentTimeMillis();
            this.mDurationMs = durationMs;
            this.mOldScale = oldScale;
            this.mDeltaScale = deltaScale;
            this.mDestX = destX;
            this.mDestY = destY;
        }

        @Override
        public void run() {
            CropImageView cropImageView = (CropImageView)((Object)this.mCropImageView.get());
            if (cropImageView == null) {
                return;
            }
            long now = System.currentTimeMillis();
            float currentMs = Math.min(this.mDurationMs, now - this.mStartTime);
            float newScale = CubicEasing.easeInOut(currentMs, 0.0f, this.mDeltaScale, this.mDurationMs);
            if (currentMs < (float)this.mDurationMs) {
                cropImageView.zoomInImage(this.mOldScale + newScale, this.mDestX, this.mDestY);
                cropImageView.post(this);
            } else {
                cropImageView.setImageToWrapCropBounds();
            }
        }
    }

    private static class WrapCropBoundsRunnable
    implements Runnable {
        private final WeakReference<CropImageView> mCropImageView;
        private final long mDurationMs;
        private final long mStartTime;
        private final float mOldX;
        private final float mOldY;
        private final float mCenterDiffX;
        private final float mCenterDiffY;
        private final float mOldScale;
        private final float mDeltaScale;
        private final boolean mWillBeImageInBoundsAfterTranslate;

        public WrapCropBoundsRunnable(CropImageView cropImageView, long durationMs, float oldX, float oldY, float centerDiffX, float centerDiffY, float oldScale, float deltaScale, boolean willBeImageInBoundsAfterTranslate) {
            this.mCropImageView = new WeakReference<CropImageView>(cropImageView);
            this.mDurationMs = durationMs;
            this.mStartTime = System.currentTimeMillis();
            this.mOldX = oldX;
            this.mOldY = oldY;
            this.mCenterDiffX = centerDiffX;
            this.mCenterDiffY = centerDiffY;
            this.mOldScale = oldScale;
            this.mDeltaScale = deltaScale;
            this.mWillBeImageInBoundsAfterTranslate = willBeImageInBoundsAfterTranslate;
        }

        @Override
        public void run() {
            CropImageView cropImageView = (CropImageView)((Object)this.mCropImageView.get());
            if (cropImageView == null) {
                return;
            }
            long now = System.currentTimeMillis();
            float currentMs = Math.min(this.mDurationMs, now - this.mStartTime);
            float newX = CubicEasing.easeOut(currentMs, 0.0f, this.mCenterDiffX, this.mDurationMs);
            float newY = CubicEasing.easeOut(currentMs, 0.0f, this.mCenterDiffY, this.mDurationMs);
            float newScale = CubicEasing.easeInOut(currentMs, 0.0f, this.mDeltaScale, this.mDurationMs);
            if (currentMs < (float)this.mDurationMs) {
                cropImageView.postTranslate(newX - (cropImageView.mCurrentImageCenter[0] - this.mOldX), newY - (cropImageView.mCurrentImageCenter[1] - this.mOldY));
                if (!this.mWillBeImageInBoundsAfterTranslate) {
                    cropImageView.zoomInImage(this.mOldScale + newScale, cropImageView.mCropRect.centerX(), cropImageView.mCropRect.centerY());
                }
                if (!cropImageView.isImageWrapCropBounds()) {
                    cropImageView.post(this);
                }
            }
        }
    }
}

