/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.net.HostName;
import com.yahoo.protect.Process;
import com.yahoo.vespa.zookeeper.ExponentialBackoff;
import com.yahoo.vespa.zookeeper.QuorumPeer;
import com.yahoo.vespa.zookeeper.ReconfigException;
import com.yahoo.vespa.zookeeper.Sleeper;
import com.yahoo.vespa.zookeeper.VespaZooKeeperAdmin;
import com.yahoo.vespa.zookeeper.VespaZooKeeperServer;
import com.yahoo.vespa.zookeeper.ZooKeeperRunner;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Reconfigurer
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(Reconfigurer.class.getName());
    private static final Duration MIN_TIMEOUT = Duration.ofMinutes(3L);
    private static final Duration NODE_TIMEOUT = Duration.ofMinutes(1L);
    private final ExponentialBackoff backoff = new ExponentialBackoff(Duration.ofSeconds(1L), Duration.ofSeconds(10L));
    private final VespaZooKeeperAdmin vespaZooKeeperAdmin;
    private final Sleeper sleeper;
    private QuorumPeer peer;
    private ZooKeeperRunner zooKeeperRunner;
    private ZookeeperServerConfig activeConfig;

    @Inject
    public Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin) {
        this(vespaZooKeeperAdmin, new Sleeper());
    }

    Reconfigurer(VespaZooKeeperAdmin vespaZooKeeperAdmin, Sleeper sleeper) {
        this.vespaZooKeeperAdmin = Objects.requireNonNull(vespaZooKeeperAdmin);
        this.sleeper = Objects.requireNonNull(sleeper);
    }

    void startOrReconfigure(ZookeeperServerConfig newConfig, VespaZooKeeperServer server, Supplier<QuorumPeer> quorumPeerGetter, Consumer<QuorumPeer> quorumPeerSetter) {
        if (this.zooKeeperRunner == null) {
            this.peer = quorumPeerGetter.get();
            this.zooKeeperRunner = this.startServer(newConfig, server);
        }
        quorumPeerSetter.accept(this.peer);
        if (this.shouldReconfigure(newConfig)) {
            this.reconfigure(newConfig);
        }
    }

    ZookeeperServerConfig activeConfig() {
        return this.activeConfig;
    }

    void shutdown() {
        if (this.zooKeeperRunner != null) {
            this.zooKeeperRunner.shutdown();
        }
    }

    private boolean shouldReconfigure(ZookeeperServerConfig newConfig) {
        if (!newConfig.dynamicReconfiguration()) {
            return false;
        }
        if (this.activeConfig == null) {
            return false;
        }
        return !newConfig.equals((Object)this.activeConfig());
    }

    private ZooKeeperRunner startServer(ZookeeperServerConfig zookeeperServerConfig, VespaZooKeeperServer server) {
        ZooKeeperRunner runner = new ZooKeeperRunner(zookeeperServerConfig, server);
        this.activeConfig = zookeeperServerConfig;
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigure(ZookeeperServerConfig newConfig) {
        Instant reconfigTriggered = Instant.now();
        if (newConfig.server().size() == 1) {
            this.shutdownAndDie(Duration.ZERO);
        }
        List<String> newServers = Reconfigurer.difference(Reconfigurer.servers(newConfig), Reconfigurer.servers(this.activeConfig));
        String leavingServerIds = String.join((CharSequence)",", Reconfigurer.serverIdsDifference(this.activeConfig, newConfig));
        String joiningServersSpec = String.join((CharSequence)",", newServers);
        leavingServerIds = leavingServerIds.isEmpty() ? null : leavingServerIds;
        joiningServersSpec = joiningServersSpec.isEmpty() ? null : joiningServersSpec;
        log.log(Level.INFO, "Will reconfigure ZooKeeper cluster. \nJoining servers: " + joiningServersSpec + "\nleaving servers: " + leavingServerIds + "\nServers in active config:" + Reconfigurer.servers(this.activeConfig) + "\nServers in new config:" + Reconfigurer.servers(newConfig));
        String connectionSpec = Reconfigurer.localConnectionSpec(this.activeConfig);
        Instant now = Instant.now();
        Duration reconfigTimeout = Reconfigurer.reconfigTimeout(newServers.size());
        Instant end = now.plus(reconfigTimeout);
        int attempt = 1;
        while (now.isBefore(end)) {
            try {
                Instant reconfigStarted = Instant.now();
                this.vespaZooKeeperAdmin.reconfigure(connectionSpec, joiningServersSpec, leavingServerIds);
                Instant reconfigEnded = Instant.now();
                log.log(Level.INFO, "Reconfiguration completed in " + Duration.between(reconfigTriggered, reconfigEnded) + ", after " + attempt + " attempt(s). ZooKeeper reconfig call took " + Duration.between(reconfigStarted, reconfigEnded));
                this.activeConfig = newConfig;
                return;
            }
            catch (ReconfigException e) {
                Duration delay = this.backoff.delay(attempt);
                log.log(Level.WARNING, "Reconfiguration attempt " + attempt + " failed. Retrying in " + delay + ", time left " + Duration.between(now, end) + ": " + Exceptions.toMessageString((Throwable)e));
                this.sleeper.sleep(delay);
            }
            finally {
                now = Instant.now();
            }
            ++attempt;
        }
        this.shutdownAndDie(reconfigTimeout);
    }

    private void shutdownAndDie(Duration reconfigTimeout) {
        this.shutdown();
        Process.logAndDie((String)("Reconfiguration did not complete within timeout " + reconfigTimeout + ". Forcing container shutdown."));
    }

    private static Duration reconfigTimeout(int joiningServers) {
        return Duration.ofMillis(Math.max((long)joiningServers * NODE_TIMEOUT.toMillis(), MIN_TIMEOUT.toMillis()));
    }

    private static String localConnectionSpec(ZookeeperServerConfig config) {
        return HostName.getLocalhost() + ":" + config.clientPort();
    }

    private static List<String> serverIdsDifference(ZookeeperServerConfig oldConfig, ZookeeperServerConfig newConfig) {
        return Reconfigurer.difference(Reconfigurer.servers(oldConfig), Reconfigurer.servers(newConfig)).stream().map(server -> server.substring(0, server.indexOf(61))).collect(Collectors.toList());
    }

    private static List<String> servers(ZookeeperServerConfig config) {
        return config.server().stream().map(server -> server.id() + "=" + server.hostname() + ":" + server.quorumPort() + ":" + server.electionPort() + ";" + config.clientPort()).collect(Collectors.toList());
    }

    private static <T> List<T> difference(List<T> list1, List<T> list2) {
        ArrayList<T> copy = new ArrayList<T>(list1);
        copy.removeAll(list2);
        return copy;
    }
}

