/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class NativeIO {
    private static final Logger logger = Logger.getLogger(NativeIO.class.getName());
    private static final int POSIX_FADV_DONTNEED = 4;
    private static boolean initialized = false;
    private static Throwable initError = null;
    private static final Field fieldFD;

    private static native int posix_fadvise(int var0, long var1, long var3, int var5) throws LastErrorException;

    public NativeIO() {
        if (!initialized) {
            logger.warning("native IO not possible due to " + this.getError().getMessage());
        }
    }

    public boolean valid() {
        return initialized;
    }

    public Throwable getError() {
        if (initError != null) {
            return initError;
        }
        return new RuntimeException("Platform is uns\u00fapported. Only supported on linux.");
    }

    public void dropPartialFileFromCache(FileDescriptor fd, long offset, long len, boolean sync) {
        if (sync) {
            try {
                fd.sync();
            }
            catch (SyncFailedException e) {
                logger.warning("Sync failed while dropping cache: " + e.getMessage());
            }
        }
        if (initialized) {
            NativeIO.posix_fadvise(NativeIO.getNativeFD(fd), offset, len, 4);
        }
    }

    public void dropFileFromCache(FileDescriptor fd) {
        this.dropPartialFileFromCache(fd, 0L, 0L, true);
    }

    public void dropFileFromCache(File file) {
        try {
            this.dropFileFromCache(new FileInputStream(file).getFD());
        }
        catch (FileNotFoundException e) {
            logger.fine("No point in dropping a non-existing file from the buffer cache: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return field;
    }

    private static int getNativeFD(FileDescriptor fd) {
        try {
            return fieldFD.getInt(fd);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            if (Platform.isLinux()) {
                Native.register((String)Platform.C_LIBRARY_NAME);
                initialized = true;
            }
        }
        catch (Throwable throwable) {
            initError = throwable;
        }
        fieldFD = NativeIO.getField(FileDescriptor.class, "fd");
    }
}

