/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.transaction;

import com.yahoo.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class NestedTransaction
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(NestedTransaction.class.getName());
    private final List<ConstrainedTransaction> transactions = new ArrayList<ConstrainedTransaction>(2);
    private final List<Runnable> onCommitted = new ArrayList<Runnable>(2);

    @SafeVarargs
    public final NestedTransaction add(Transaction transaction, Class<? extends Transaction> ... before) {
        this.transactions.add(new ConstrainedTransaction(transaction, before));
        return this;
    }

    public List<Transaction> transactions() {
        return this.organizeTransactions(this.transactions);
    }

    public void commit() {
        List<Transaction> organizedTransactions = this.organizeTransactions(this.transactions);
        for (Transaction transaction : organizedTransactions) {
            transaction.prepare();
        }
        ListIterator<Transaction> i = organizedTransactions.listIterator();
        while (i.hasNext()) {
            Transaction transaction;
            transaction = i.next();
            try {
                transaction.commit();
            }
            catch (Exception e) {
                i.previous();
                while (i.hasPrevious()) {
                    i.previous().rollbackOrLog();
                }
                throw new IllegalStateException("Transaction failed during commit", e);
            }
        }
        for (Runnable task : this.onCommitted) {
            try {
                task.run();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "A committed task in " + this + " caused an exception", e);
            }
        }
    }

    public void onCommitted(Runnable runnable) {
        this.onCommitted.add(runnable);
    }

    @Override
    public void close() {
        for (ConstrainedTransaction transaction : this.transactions) {
            transaction.transaction.close();
        }
    }

    private List<Transaction> organizeTransactions(List<ConstrainedTransaction> transactions) {
        return this.orderTransactions(this.combineTransactions(transactions), this.findOrderingConstraints(transactions));
    }

    private List<Transaction> combineTransactions(List<ConstrainedTransaction> transactions) {
        ArrayList<Transaction> combinedTransactions = new ArrayList<Transaction>(transactions.size());
        for (List<Transaction> combinableTransactions : transactions.stream().map(ConstrainedTransaction::transaction).collect(Collectors.groupingBy(Object::getClass)).values()) {
            Transaction combinedTransaction = combinableTransactions.get(0);
            for (int i = 1; i < combinableTransactions.size(); ++i) {
                combinedTransaction = combinedTransaction.add(combinableTransactions.get(i).operations());
            }
            combinedTransactions.add(combinedTransaction);
        }
        return combinedTransactions;
    }

    private List<OrderingConstraint> findOrderingConstraints(List<ConstrainedTransaction> transactions) {
        ArrayList<OrderingConstraint> orderingConstraints = new ArrayList<OrderingConstraint>(1);
        for (ConstrainedTransaction transaction : transactions) {
            for (Class<? extends Transaction> afterThis : transaction.before()) {
                orderingConstraints.add(new OrderingConstraint(transaction.transaction().getClass(), afterThis));
            }
        }
        return orderingConstraints;
    }

    private List<Transaction> orderTransactions(List<Transaction> transactions, List<OrderingConstraint> constraints) {
        if (transactions.size() == 1) {
            return transactions;
        }
        ArrayList<Transaction> orderedTransactions = new ArrayList<Transaction>();
        for (Transaction transaction : transactions) {
            orderedTransactions.add(this.findSuitablePositionFor(transaction, orderedTransactions, constraints), transaction);
        }
        return orderedTransactions;
    }

    private int findSuitablePositionFor(Transaction transaction, List<Transaction> orderedTransactions, List<OrderingConstraint> constraints) {
        for (int i = 0; i < orderedTransactions.size(); ++i) {
            Transaction candidateNextTransaction = orderedTransactions.get(i);
            if (!this.mustBeAfter(candidateNextTransaction.getClass(), transaction.getClass(), constraints)) {
                return i;
            }
            if (!this.mustBeAfter(transaction.getClass(), candidateNextTransaction.getClass(), constraints)) continue;
            throw new IllegalStateException("Conflicting transaction ordering constraints between" + transaction + " and " + candidateNextTransaction);
        }
        return orderedTransactions.size();
    }

    private boolean mustBeAfter(Class<? extends Transaction> a, Class<? extends Transaction> b, List<OrderingConstraint> constraints) {
        for (OrderingConstraint fromA : this.findAllOrderingConstraintsFrom(a, constraints)) {
            if (fromA.after().equals(b)) {
                return true;
            }
            if (!this.mustBeAfter(fromA.after(), b, constraints)) continue;
            return true;
        }
        return false;
    }

    private List<OrderingConstraint> findAllOrderingConstraintsFrom(Class<? extends Transaction> transactionType, List<OrderingConstraint> constraints) {
        return constraints.stream().filter(c -> c.before().equals(transactionType)).collect(Collectors.toList());
    }

    private static class OrderingConstraint {
        private final Class<? extends Transaction> before;
        private final Class<? extends Transaction> after;

        public OrderingConstraint(Class<? extends Transaction> before, Class<? extends Transaction> after) {
            this.before = before;
            this.after = after;
        }

        public Class<? extends Transaction> before() {
            return this.before;
        }

        public Class<? extends Transaction> after() {
            return this.after;
        }

        public String toString() {
            return this.before + " -> " + this.after;
        }
    }

    private static class ConstrainedTransaction {
        private final Transaction transaction;
        private final Class<? extends Transaction>[] before;

        public ConstrainedTransaction(Transaction transaction, Class<? extends Transaction>[] before) {
            this.transaction = transaction;
            this.before = before;
        }

        public Transaction transaction() {
            return this.transaction;
        }

        public Class<? extends Transaction>[] before() {
            return this.before;
        }
    }
}

