/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.annotations.Beta;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;

@Beta
public class Argmin
extends CompositeTensorFunction {
    private final TensorFunction argument;
    private final String dimension;

    public Argmin(TensorFunction argument, String dimension) {
        this.argument = argument;
        this.dimension = dimension;
    }

    @Override
    public List<TensorFunction> functionArguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction replaceArguments(List<TensorFunction> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Argmin must have 1 argument, got " + arguments.size());
        }
        return new Argmin(arguments.get(0), this.dimension);
    }

    @Override
    public PrimitiveTensorFunction toPrimitive() {
        PrimitiveTensorFunction primitiveArgument = this.argument.toPrimitive();
        return new Join(primitiveArgument, new Reduce((TensorFunction)primitiveArgument, Reduce.Aggregator.min, this.dimension), ScalarFunctions.equal());
    }

    @Override
    public String toString(ToStringContext context) {
        return "argmin(" + this.argument.toString(context) + ", " + this.dimension + ")";
    }
}

