/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.annotations.Beta;
import com.yahoo.tensor.TensorType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
class TensorTypeParser {
    private static final String START_STRING = "tensor(";
    private static final String END_STRING = ")";
    private static final Pattern indexedPattern = Pattern.compile("(\\w+)\\[(\\d*)\\]");
    private static final Pattern mappedPattern = Pattern.compile("(\\w+)\\{\\}");

    TensorTypeParser() {
    }

    static TensorType fromSpec(String specString) {
        if (!specString.startsWith(START_STRING) || !specString.endsWith(END_STRING)) {
            throw new IllegalArgumentException("Tensor type spec must start with 'tensor(' and end with ')', but was '" + specString + "'");
        }
        TensorType.Builder builder = new TensorType.Builder();
        String dimensionsSpec = specString.substring(START_STRING.length(), specString.length() - END_STRING.length());
        if (dimensionsSpec.isEmpty()) {
            return builder.build();
        }
        for (String element : dimensionsSpec.split(",")) {
            String trimmedElement = element.trim();
            if (TensorTypeParser.tryParseIndexedDimension(trimmedElement, builder) || TensorTypeParser.tryParseMappedDimension(trimmedElement, builder)) continue;
            throw new IllegalArgumentException("Failed parsing element '" + element + "' in type spec '" + specString + "'");
        }
        return builder.build();
    }

    private static boolean tryParseIndexedDimension(String element, TensorType.Builder builder) {
        Matcher matcher = indexedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            String dimensionSize = matcher.group(2);
            if (dimensionSize.isEmpty()) {
                builder.indexed(dimensionName);
            } else {
                builder.indexed(dimensionName, Integer.valueOf(dimensionSize));
            }
            return true;
        }
        return false;
    }

    private static boolean tryParseMappedDimension(String element, TensorType.Builder builder) {
        Matcher matcher = mappedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            builder.mapped(dimensionName);
            return true;
        }
        return false;
    }
}

