/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.annotations.Beta;
import java.util.Arrays;

@Beta
public final class DimensionSizes {
    private final int[] sizes;

    private DimensionSizes(Builder builder) {
        this.sizes = builder.sizes;
        Builder.access$002(builder, null);
    }

    public int size(int dimensionIndex) {
        return this.sizes[dimensionIndex];
    }

    public int dimensions() {
        return this.sizes.length;
    }

    public int totalSize() {
        int productSize = 1;
        for (int dimensionSize : this.sizes) {
            productSize *= dimensionSize;
        }
        return productSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionSizes)) {
            return false;
        }
        return Arrays.equals(((DimensionSizes)o).sizes, this.sizes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sizes);
    }

    public static final class Builder {
        private int[] sizes;

        public Builder(int dimensions) {
            this.sizes = new int[dimensions];
        }

        public Builder set(int dimensionIndex, int size) {
            this.sizes[dimensionIndex] = size;
            return this;
        }

        public int size(int dimensionIndex) {
            return this.sizes[dimensionIndex];
        }

        public int dimensions() {
            return this.sizes.length;
        }

        public DimensionSizes build() {
            return new DimensionSizes(this);
        }

        static /* synthetic */ int[] access$002(Builder x0, int[] x1) {
            x0.sizes = x1;
            return x1;
        }
    }
}

