/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostName {
    private static final Logger logger = Logger.getLogger(HostName.class.getName());
    private static String cachedHostName = null;

    public static synchronized String getLocalhost() {
        if (cachedHostName == null) {
            try {
                cachedHostName = HostName.getPreferredHostName();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to find a preferred hostname", e);
            }
        }
        return cachedHostName;
    }

    private static String getPreferredHostName() throws Exception {
        String systemHostName = HostName.getSystemHostName();
        if (HostName.isReachable(systemHostName)) {
            return systemHostName;
        }
        ArrayList<InetAddress> reachableNonLocalIp4Addresses = new ArrayList<InetAddress>();
        ArrayList<InetAddress> reachableNonLocalIp6Addresses = new ArrayList<InetAddress>();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            for (InetAddress ipAddress : Collections.list(networkInterface.getInetAddresses())) {
                if (!HostName.isReachable(ipAddress)) continue;
                if (ipAddress instanceof Inet4Address) {
                    reachableNonLocalIp4Addresses.add(ipAddress);
                    continue;
                }
                reachableNonLocalIp6Addresses.add(ipAddress);
            }
        }
        Optional<String> reachableHostName = HostName.getAnyHostNameInDns(reachableNonLocalIp4Addresses);
        if (reachableHostName.isPresent()) {
            return reachableHostName.get();
        }
        reachableHostName = HostName.getAnyHostNameInDns(reachableNonLocalIp6Addresses);
        if (reachableHostName.isPresent()) {
            return reachableHostName.get();
        }
        if (!reachableNonLocalIp4Addresses.isEmpty()) {
            return ((InetAddress)reachableNonLocalIp4Addresses.get(0)).getHostName();
        }
        if (!reachableNonLocalIp6Addresses.isEmpty()) {
            return ((InetAddress)reachableNonLocalIp6Addresses.get(0)).getHostName();
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private static Optional<String> getAnyHostNameInDns(List<InetAddress> ipAddresses) {
        for (InetAddress ipAddress : ipAddresses) {
            String hostname = ipAddress.getCanonicalHostName();
            if (Objects.equals(hostname, ipAddress.getHostAddress())) continue;
            return Optional.of(hostname);
        }
        return Optional.empty();
    }

    static String getSystemHostName() throws Exception {
        String env = System.getenv("VESPA_HOSTNAME");
        if (env != null && !env.trim().isEmpty()) {
            return env.trim();
        }
        Process process = Runtime.getRuntime().exec("hostname");
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String hostname = in.readLine();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new RuntimeException("Command 'hostname' failed with exit code " + process.exitValue());
        }
        return hostname;
    }

    private static Optional<String> getHostNameIfReachable(InetAddress ipAddress) {
        if (!HostName.isReachable(ipAddress)) {
            return Optional.empty();
        }
        String hostname = ipAddress.getCanonicalHostName();
        if (Objects.equals(hostname, ipAddress.getHostAddress())) {
            return Optional.empty();
        }
        return Optional.of(hostname);
    }

    private static boolean isReachable(String hostname) {
        try {
            InetAddress ipAddress = InetAddress.getByName(hostname);
            return HostName.isReachable(ipAddress);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private static boolean isReachable(InetAddress ipAddress) {
        try {
            int timeoutMs = 100;
            if (!ipAddress.isReachable(timeoutMs)) {
                logger.log(Level.INFO, ipAddress.toString() + " is unreachable w/" + timeoutMs + "ms timeout, ignoring address");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed testing reachability of " + ipAddress + ", ignoring address", e);
            return false;
        }
    }
}

