/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ReadLine {
    private static Charset charset = Charset.forName("latin1");

    public static String readLine(ByteBuffer buffer) {
        int start;
        for (int i = start = buffer.position(); i < buffer.limit(); ++i) {
            if (!ReadLine.isEolChar(buffer.get(i))) continue;
            if (i == start) {
                while (i < buffer.limit() && ReadLine.isEolChar(buffer.get(i))) {
                    ++i;
                }
                start = i;
                buffer.position(i);
                continue;
            }
            String line = charset.decode((ByteBuffer)buffer.slice().limit(i - start)).toString();
            while (i < buffer.limit() && ReadLine.isEolChar(buffer.get(i))) {
                ++i;
            }
            buffer.position(i);
            return line;
        }
        if (buffer.hasRemaining()) {
            buffer.compact();
        } else {
            buffer.clear();
        }
        return null;
    }

    static boolean isEolChar(byte b) {
        return 10 == b || 13 == b;
    }
}

