/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.errorhandling;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Results<DATA, ERROR> {
    private final List<DATA> data;
    private final List<ERROR> errors;

    public Results(List<DATA> data, List<ERROR> errors) {
        this.data = ImmutableList.copyOf(data);
        this.errors = ImmutableList.copyOf(errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<DATA> data() {
        return this.data;
    }

    public List<ERROR> errors() {
        return this.errors;
    }

    public static class Builder<DATA, ERROR> {
        private final List<DATA> data = new ArrayList<DATA>();
        private final List<ERROR> errors = new ArrayList<ERROR>();

        public void addData(DATA d) {
            this.data.add(d);
        }

        public void addAllData(Collection<? extends DATA> d) {
            this.data.addAll(d);
        }

        public void addError(ERROR e) {
            this.errors.add(e);
        }

        public void addAllErrors(Collection<? extends ERROR> e) {
            this.errors.addAll(e);
        }

        public Results<DATA, ERROR> build() {
            return new Results<DATA, ERROR>(this.data, this.errors);
        }
    }
}

