/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ListMap<K, V> {
    private boolean frozen = false;
    private Map<K, List<V>> map;

    public ListMap() {
        this(HashMap.class);
    }

    public ListMap(Class<? extends Map> implementation) {
        try {
            this.map = implementation.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void put(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public void removeAll(K key) {
        this.map.remove(key);
    }

    public boolean removeValue(K key, V value) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list.remove(value);
        }
        return false;
    }

    public V removeValue(K key, int index) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list.remove(index);
        }
        throw new IndexOutOfBoundsException("The list at '" + key + "' is empty");
    }

    public List<V> get(K key) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list);
    }

    public List<V> getList(K key) {
        return this.get(key);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<List<V>> values() {
        return this.map.values();
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        for (Map.Entry<K, List<ImmutableList>> entry : this.map.entrySet()) {
            entry.setValue((List<ImmutableList>)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.map = ImmutableMap.copyOf(this.map);
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int size() {
        return this.map.size();
    }
}

