/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.security.tool.crypto;

import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.vespa.security.tool.ConsoleInput;
import com.yahoo.vespa.security.tool.ToolInvocation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.interfaces.XECPrivateKey;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;

public class ToolUtils {
    static final String PRIVATE_KEY_FILE_OPTION = "private-key-file";
    static final String PRIVATE_KEY_DIR_OPTION = "private-key-dir";
    static final String NO_INTERACTIVE_OPTION = "no-interactive";
    static final String PRIVATE_KEY_DIR_ENV_VAR = "VESPA_CRYPTO_CLI_PRIVATE_KEY_DIR";
    static final Pattern SAFE_KEY_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");

    static void verifyExpectedKeyId(SealedSharedKey sealedSharedKey, Optional<String> maybeKeyId) {
        KeyId myKeyId;
        if (maybeKeyId.isPresent() && !(myKeyId = KeyId.ofString((String)maybeKeyId.get())).equals((Object)sealedSharedKey.keyId())) {
            throw new IllegalArgumentException("Key ID specified with --expected-key-id does not match key ID used when generating the supplied token");
        }
    }

    private static void verifyKeyIdIsPathSafe(KeyId keyId) {
        String keyIdStr = keyId.asString();
        if (!SAFE_KEY_ID_PATTERN.matcher(keyIdStr).matches()) {
            throw new IllegalArgumentException("The token key ID is not comprised of path-safe characters; refusing to use it");
        }
    }

    private static void verifyPrivateKeyFileNotWorldReadable(Path keyPath) throws IOException {
        Set<PosixFilePermission> privKeyPerms = Files.getPosixFilePermissions(keyPath, new LinkOption[0]);
        if (privKeyPerms.contains((Object)PosixFilePermission.OTHERS_READ)) {
            throw new IllegalArgumentException("Private key file '%s' is insecurely world-readable; refusing to read it".formatted(keyPath.toAbsolutePath()));
        }
    }

    private static XECPrivateKey attemptResolvePrivateKeyFromDir(Path privKeyDirPath, KeyId tokenKeyId) throws IOException {
        if (!Files.isDirectory(privKeyDirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("'%s' is not a valid directory".formatted(privKeyDirPath.toAbsolutePath()));
        }
        ToolUtils.verifyKeyIdIsPathSafe(tokenKeyId);
        Path keyPath = privKeyDirPath.resolve(tokenKeyId.asString() + ".key");
        if (!Files.exists(keyPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find a private key file matching token key ID '%s'".formatted(tokenKeyId.asString()));
        }
        ToolUtils.verifyPrivateKeyFileNotWorldReadable(keyPath);
        return KeyUtils.fromBase58EncodedX25519PrivateKey((String)Files.readString(keyPath).strip());
    }

    public static XECPrivateKey resolvePrivateKeyFromInvocation(ToolInvocation invocation, KeyId tokenKeyId, boolean mayReadKeyFromStdIn) throws IOException {
        CommandLine arguments = invocation.arguments();
        Map<String, String> envVars = invocation.envVars();
        ConsoleInput console = invocation.consoleInputOrNull();
        if (arguments.hasOption(PRIVATE_KEY_FILE_OPTION)) {
            if (arguments.hasOption(PRIVATE_KEY_DIR_OPTION)) {
                throw new IllegalArgumentException("--%s and --%s cannot be specified at the same time".formatted(PRIVATE_KEY_FILE_OPTION, PRIVATE_KEY_DIR_OPTION));
            }
            Path privKeyFilePath = Paths.get(arguments.getOptionValue(PRIVATE_KEY_FILE_OPTION), new String[0]);
            invocation.printIfDebug(() -> "Using private key file '%s'".formatted(privKeyFilePath));
            if (!Files.exists(privKeyFilePath, new LinkOption[0])) {
                throw new IllegalArgumentException("Specified private key file '%s' does not exist".formatted(privKeyFilePath.toAbsolutePath()));
            }
            ToolUtils.verifyPrivateKeyFileNotWorldReadable(privKeyFilePath);
            return KeyUtils.fromBase58EncodedX25519PrivateKey((String)Files.readString(privKeyFilePath).strip());
        }
        if (arguments.hasOption(PRIVATE_KEY_DIR_OPTION) || envVars.containsKey(PRIVATE_KEY_DIR_ENV_VAR)) {
            Path privKeyDirPath = Paths.get(arguments.hasOption(PRIVATE_KEY_DIR_OPTION) ? arguments.getOptionValue(PRIVATE_KEY_DIR_OPTION) : envVars.get(PRIVATE_KEY_DIR_ENV_VAR), new String[0]);
            invocation.printIfDebug(() -> "Using private key lookup directory '%s'".formatted(privKeyDirPath));
            return ToolUtils.attemptResolvePrivateKeyFromDir(privKeyDirPath, tokenKeyId);
        }
        if (arguments.hasOption(NO_INTERACTIVE_OPTION) || console == null || !mayReadKeyFromStdIn) {
            throw new IllegalArgumentException("No private key specified. Must specify either --%s or --%s".formatted(PRIVATE_KEY_FILE_OPTION, PRIVATE_KEY_DIR_OPTION));
        }
        ToolUtils.verifyKeyIdIsPathSafe(tokenKeyId);
        String key = console.readPassword("Private key for key id '%s' in Base-58 format: ", tokenKeyId.asString());
        if (key.length() == 0) {
            throw new IllegalArgumentException("No private key provided; aborting");
        }
        return KeyUtils.fromBase58EncodedX25519PrivateKey((String)key);
    }
}

