/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespavisit;

import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorDestinationSession;
import com.yahoo.documentapi.messagebus.MessageBusDocumentAccess;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.log.LogSetup;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.net.HostName;
import com.yahoo.vespavisit.StdOutVisitorHandler;
import com.yahoo.vespavisit.VdsVisitHandler;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class VdsVisitTarget {
    private static final Logger log = Logger.getLogger(VdsVisitTarget.class.getName());
    private boolean printIds = false;
    DocumentAccess access;
    VisitorDestinationSession session;
    String slobrokAddress = null;
    int port = -1;
    private boolean verbose = false;
    private int processTime = 0;
    private String handlerClassName = StdOutVisitorHandler.class.getName();
    private String[] handlerArgs = null;

    public boolean isPrintIds() {
        return this.printIds;
    }

    public String getSlobrokAddress() {
        return this.slobrokAddress;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getPort() {
        return this.port;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public String[] getHandlerArgs() {
        return this.handlerArgs;
    }

    public static void main(String[] args) {
        LogSetup.initVespaLogging((String)"vespa-visit-target");
        VdsVisitTarget visitTarget = new VdsVisitTarget();
        try {
            visitTarget.parseArguments(args);
            visitTarget.initShutdownHook();
            visitTarget.run();
            System.exit(0);
        }
        catch (HelpShownException e) {
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (ParseException e) {
            System.err.println("Failed to parse arguments. Try --help for syntax. " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Show this syntax page.");
        options.addOption(Option.builder((String)"s").longOpt("bindtoslobrok").hasArg(true).argName("address").desc("Bind to the given location broker address.").build());
        options.addOption(Option.builder((String)"t").longOpt("bindtosocket").hasArg(true).argName("port").desc("Bind to the given TCP port").type(Number.class).build());
        options.addOption(Option.builder((String)"p").longOpt("processtime").hasArg(true).argName("msecs").desc("Sleep this amount of millisecs before processing message. (Debug option for pretending to be slow client).").type(Number.class).build());
        options.addOption(Option.builder((String)"c").longOpt("visithandler").hasArg(true).argName("classname").desc("Use the given class as a visit handler (defaults to StdOutVisitorHandler)").build());
        options.addOption(Option.builder((String)"o").longOpt("visitoptions").hasArg(true).argName("args").desc("Option arguments to pass through to the visitor handler instance").build());
        options.addOption("i", "printids", false, "Display only document identifiers.");
        options.addOption("v", "verbose", false, "Indent XML, show progress and info on STDERR.");
        return options;
    }

    private void printSyntax(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("vespa-visit-target <options>", "Retrieve results from a visitor", options, "One, and only one, of the binding options must be present.\n\nFor more detailed information, such as defaults and format of\narguments, refer to 'man vespa-visit-target'.\n");
    }

    void parseArguments(String[] args) throws ParseException, HelpShownException {
        DefaultParser parser = new DefaultParser();
        Options options = VdsVisitTarget.createOptions();
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("h")) {
            this.printSyntax(options);
            throw new HelpShownException();
        }
        if (line.hasOption("s")) {
            this.slobrokAddress = line.getOptionValue("s");
        }
        if (line.hasOption("t")) {
            this.port = ((Number)line.getParsedOptionValue("t")).intValue();
        }
        if (line.hasOption("i")) {
            this.printIds = true;
        }
        if (line.hasOption("p")) {
            this.processTime = ((Number)line.getParsedOptionValue("p")).intValue();
        }
        if (line.hasOption("v")) {
            this.verbose = true;
        }
        if (line.hasOption("c")) {
            this.handlerClassName = line.getOptionValue("c");
        }
        if (line.hasOption("o")) {
            this.handlerArgs = line.getOptionValue("o").split(" ");
        }
        if (!(this.slobrokAddress == null ^ this.port == -1)) {
            throw new IllegalArgumentException("You must specify one, and only one, binding option");
        }
        if (this.port != -1 && this.port < 0 || this.port > 65535) {
            throw new IllegalArgumentException("The port must be in the range 0-65535");
        }
        if (this.verbose) {
            if (this.port != -1) {
                System.err.println("Binding to socket " + this.getTcpAddress());
            } else {
                System.err.println("Binding to location broker address: " + this.slobrokAddress + "/visit-destination");
            }
        }
    }

    private String getTcpAddress() {
        String hostname = HostName.getLocalhost();
        return "tcp/" + hostname + ":" + this.port + "/visit-destination";
    }

    public void run() throws Exception {
        VdsVisitHandler handler;
        this.initShutdownHook();
        log.log(Level.FINE, "Starting VdsVisitTarget");
        MessageBusParams mbusParams = new MessageBusParams();
        mbusParams.getRPCNetworkParams().setIdentity(new Identity(this.slobrokAddress));
        if (this.port > 0) {
            mbusParams.getRPCNetworkParams().setListenPort(this.port);
        }
        this.access = new MessageBusDocumentAccess(mbusParams);
        Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(this.handlerClassName);
        try {
            Class[] consTypes = new Class[]{Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, String[].class};
            Constructor<?> cons = cls.getConstructor(consTypes);
            handler = (VdsVisitHandler)cons.newInstance(this.printIds, this.verbose, this.verbose, this.verbose, false, false, this.processTime, this.handlerArgs);
        }
        catch (NoSuchMethodException e) {
            Class[] consTypes = new Class[]{Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE};
            Constructor<?> cons = cls.getConstructor(consTypes);
            handler = (VdsVisitHandler)cons.newInstance(this.printIds, this.verbose, this.verbose, this.verbose, false, false, this.processTime, false);
        }
        VisitorDataHandler dataHandler = handler.getDataHandler();
        VisitorControlHandler controlHandler = handler.getControlHandler();
        VisitorDestinationParameters params = new VisitorDestinationParameters("visit-destination", dataHandler);
        this.session = this.access.createVisitorDestinationSession(params);
        while (!controlHandler.isDone()) {
            Thread.sleep(1000L);
        }
    }

    private void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new CleanUpThread());
    }

    class HelpShownException
    extends Exception {
        HelpShownException() {
        }
    }

    class CleanUpThread
    extends Thread {
        CleanUpThread() {
        }

        @Override
        public void run() {
            try {
                if (VdsVisitTarget.this.session != null) {
                    VdsVisitTarget.this.session.destroy();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                if (VdsVisitTarget.this.access != null) {
                    VdsVisitTarget.this.access.shutdown();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

