/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.vespasignificance.merge;

import ai.vespa.vespasignificance.merge.TermDfRowSink;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class TermDfKWayMerge {
    public static void merge(List<BufferedReader> inputs, TermDfRowSink sink, long minKeep) throws IOException {
        PriorityQueue<Cursor> queue = new PriorityQueue<Cursor>(inputs.size(), Comparator.comparing(c -> c.term));
        for (BufferedReader reader : inputs) {
            Cursor cursor = new Cursor(reader);
            if (!cursor.advance()) continue;
            queue.offer(cursor);
        }
        while (!queue.isEmpty()) {
            String term = queue.peek().term;
            long sumDf = 0L;
            while (!queue.isEmpty() && queue.peek().term.equals(term)) {
                Cursor cursor = queue.poll();
                sumDf += cursor.documentFrequency;
                if (!cursor.advance()) continue;
                queue.offer(cursor);
            }
            if (sumDf < minKeep) continue;
            sink.write(term, sumDf);
        }
    }

    static final class Cursor {
        final BufferedReader bufferedReader;
        String term;
        long documentFrequency;
        long lineNo;

        Cursor(BufferedReader bufferedReader) {
            this.bufferedReader = bufferedReader;
            this.lineNo = 0L;
        }

        boolean advance() throws IOException {
            String line;
            while ((line = this.bufferedReader.readLine()) != null) {
                ++this.lineNo;
                if (line.trim().isEmpty()) continue;
                int tab = line.indexOf(9);
                if (tab < 0) {
                    throw new IllegalArgumentException("Missing tab at line " + this.lineNo + ": " + line);
                }
                this.term = line.substring(0, tab);
                if (this.term.isEmpty()) {
                    throw new IllegalArgumentException("Empty term at line " + this.lineNo);
                }
                String num = line.substring(tab + 1).trim();
                try {
                    this.documentFrequency = Long.parseLong(num);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid number at line " + this.lineNo + ": \"" + num + "\"", nfe);
                }
                return true;
            }
            return false;
        }
    }
}

