/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasignificance;

import com.yahoo.vespasignificance.ClientParameters;
import com.yahoo.vespasignificance.CommandLineOptions;
import com.yahoo.vespasignificance.SignificanceModelGenerator;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;

public class Main {
    public static void main(String[] args) {
        CommandLine global;
        DefaultParser parser = new DefaultParser();
        try {
            global = parser.parse(CommandLineOptions.createGlobalOptions(), args, true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String[] remaining = global.getArgs();
        if (remaining.length == 0 || global.hasOption("help")) {
            CommandLineOptions.printGlobalHelp();
            return;
        }
        String sub = remaining[0];
        String[] subArgs = Arrays.copyOfRange(remaining, 1, remaining.length);
        switch (sub) {
            case "generate": {
                Main.runGenerate(subArgs);
                break;
            }
            default: {
                System.err.println("Error: Unknown command `" + sub + "`");
                CommandLineOptions.printGlobalHelp();
            }
        }
    }

    static void runGenerate(String[] commandLineArgs) {
        try {
            CommandLineOptions options = new CommandLineOptions();
            ClientParameters params = options.parseCommandLineArguments(commandLineArgs);
            if (params.help) {
                options.printHelp();
            } else {
                System.setProperty("vespa.replace_invalid_unicode", "true");
                SignificanceModelGenerator significanceModelGenerator = Main.createSignificanceModelGenerator(params);
                significanceModelGenerator.generate();
            }
        }
        catch (IllegalArgumentException e) {
            System.err.printf("Failed to parse command line arguments: %s.\n", e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SignificanceModelGenerator createSignificanceModelGenerator(ClientParameters params) {
        return new SignificanceModelGenerator(params);
    }
}

