/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespasummarybenchmark;

import com.yahoo.compress.CompressionType;
import com.yahoo.document.GlobalId;
import com.yahoo.document.idstring.IdString;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.log.LogSetup;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class VespaSummaryBenchmark {
    private final Supervisor supervisor = new Supervisor(new Transport());
    private static final LZ4Factory lz4Factory = LZ4Factory.fastestInstance();

    private VespaSummaryBenchmark() {
    }

    private static List<String> getDocIds(String fileName) {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(fileName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> docIds = new ArrayList<String>();
            while ((strLine = br.readLine()) != null) {
                docIds.add(strLine);
            }
            in.close();
            return docIds;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Target> getTargets(String connectionSpec, int numTargets) {
        ArrayList<Target> targets = new ArrayList<Target>(numTargets);
        for (int i = 0; i < numTargets; ++i) {
            targets.add(this.supervisor.connect(new Spec(connectionSpec)));
        }
        return targets;
    }

    private static Slime createDocsumRequest(String summaryClass, List<GlobalId> gids) {
        Slime docsumRequest = new Slime();
        Cursor root = docsumRequest.setObject();
        root.setString("class", summaryClass);
        Cursor gidCursor = root.setArray("gids");
        for (GlobalId gid : gids) {
            gidCursor.addData(gid.getRawId());
        }
        return docsumRequest;
    }

    private static void fetchDocIds(String summaryClass, List<Target> targets, List<GlobalId> gids, boolean dump) {
        Slime docsumRequest = VespaSummaryBenchmark.createDocsumRequest(summaryClass, gids);
        byte[] blob = BinaryFormat.encode((Slime)docsumRequest);
        Waiter waiter = new Waiter(targets.size(), dump);
        for (Target target : targets) {
            Request r = new Request("proton.getDocsums");
            r.parameters().add((Value)new Int8Value(CompressionType.NONE.getCode()));
            r.parameters().add((Value)new Int32Value(blob.length));
            r.parameters().add((Value)new DataValue(blob));
            target.invokeAsync(r, 100.0, (RequestWaiter)waiter);
        }
        try {
            waiter.waitForReplies();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        LogSetup.initVespaLogging((String)"vespasummarybenchmark");
        String docidFileName = args[0];
        String connectionSpec = args[1];
        String summaryClass = args[2];
        int numRuns = Integer.parseInt(args[3]);
        int numTargets = Integer.parseInt(args[4]);
        VespaSummaryBenchmark benchmark = new VespaSummaryBenchmark();
        List<String> docIds = VespaSummaryBenchmark.getDocIds(docidFileName);
        ArrayList<GlobalId> gids = new ArrayList<GlobalId>(docIds.size());
        for (String docid : docIds) {
            GlobalId gid = new GlobalId(IdString.createIdString((String)docid));
            gids.add(gid);
        }
        List<Target> targets = benchmark.getTargets(connectionSpec, numTargets);
        for (int i = 0; i < numRuns; ++i) {
            VespaSummaryBenchmark.fetchDocIds(summaryClass, targets, gids, i == 0);
        }
    }

    private static class Waiter
    implements RequestWaiter {
        int waitingFor;
        boolean dump;

        Waiter(int expect, boolean dump) {
            this.waitingFor = expect;
            this.dump = dump;
        }

        private void print(Request request) {
            Values ret = request.returnValues();
            CompressionType type = CompressionType.valueOf((byte)ret.get(0).asInt8());
            int uncompressedSize = ret.get(1).asInt32();
            byte[] blob = ret.get(2).asData();
            if (type == CompressionType.LZ4) {
                byte[] uncompressed;
                LZ4FastDecompressor decompressor = lz4Factory.fastDecompressor();
                int compressedLength = decompressor.decompress(blob, 0, uncompressed = new byte[uncompressedSize], 0, uncompressedSize);
                if (compressedLength != blob.length) {
                    throw new DeserializationException("LZ4 decompression failed. compressed size does not match. Expected " + blob.length + ". Got " + compressedLength);
                }
                blob = uncompressed;
            }
            Slime slime = BinaryFormat.decode((byte[])blob);
            try {
                new JsonFormat(true).encode((OutputStream)System.out, slime);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequestDone(Request request) {
            Waiter waiter = this;
            synchronized (waiter) {
                if (this.dump) {
                    this.print(request);
                    this.dump = false;
                }
                --this.waitingFor;
                if (this.waitingFor == 0) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForReplies() throws InterruptedException {
            Waiter waiter = this;
            synchronized (waiter) {
                while (this.waitingFor > 0) {
                    this.wait();
                }
            }
        }
    }
}

