/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class AcceptHeaderMatcher {
    private final Map<String, Double> qualityByNormalizedTypeName;

    public AcceptHeaderMatcher(String input) {
        Parser parser = new Parser(new Lexer(input));
        this.qualityByNormalizedTypeName = parser.mediaRanges().stream().collect(Collectors.toMap(mr -> AcceptHeaderMatcher.lowerCasedTypeName(mr.mediaType.cachedFullType()), MediaRange::quality, Math::max));
    }

    public List<String> preferredExactMediaTypes(String ... types) {
        ArrayList<RankedMediaType> res = new ArrayList<RankedMediaType>();
        int callerRank = 0;
        for (String candidate : types) {
            Double maybeMatch = this.qualityByNormalizedTypeName.get(AcceptHeaderMatcher.lowerCasedTypeName(candidate));
            if (maybeMatch == null) continue;
            res.add(new RankedMediaType(candidate, maybeMatch, callerRank));
            ++callerRank;
        }
        return res.stream().sorted().map(r -> r.type).toList();
    }

    private static String lowerCasedTypeName(String in) {
        return in.toLowerCase(Locale.US);
    }

    private static class Parser {
        private final Lexer lexer;
        private static final Pattern QVAL_PATTERN = Pattern.compile("^(0(\\.\\d{0,3})?|1(\\.0{0,3})?)$");

        Parser(Lexer lexer) {
            this.lexer = lexer;
        }

        List<MediaRange> mediaRanges() {
            ArrayList<MediaRange> ranges = new ArrayList<MediaRange>();
            while (!this.eof()) {
                this.skipWs();
                if (this.matchAndAdvance(TokenType.COMMA)) continue;
                ranges.add(this.mediaRange());
                this.skipWs();
                if (this.matchAndAdvance(TokenType.COMMA)) continue;
            }
            if (!this.eof()) {
                throw new IllegalArgumentException("unparsed input at end");
            }
            return ranges;
        }

        private MediaRange mediaRange() {
            MediaType mediaType = this.mediaType();
            Parameters params = this.parameters();
            double quality = 1.0;
            for (Parameter p : params.params()) {
                if (!p.key.equals("q")) continue;
                quality = Parser.parseQvalue(p.value);
            }
            return new MediaRange(mediaType, params, quality);
        }

        private static double parseQvalue(String paramValue) {
            if (QVAL_PATTERN.matcher(paramValue).matches()) {
                return Double.parseDouble(paramValue);
            }
            throw new IllegalArgumentException("bad quality parameter value");
        }

        private MediaType mediaType() {
            String type = this.token();
            this.expectAndAdvance(TokenType.FWD_SLASH);
            String subtype = this.token();
            return new MediaType(type, subtype, "%s/%s".formatted(type, subtype));
        }

        private Parameters parameters() {
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            while (true) {
                this.skipWs();
                if (!this.matchAndAdvance(TokenType.SEMICOLON)) break;
                this.skipWs();
                params.add(this.parameter());
            }
            return new Parameters(params);
        }

        private Parameter parameter() {
            String name = this.token();
            this.expectAndAdvance(TokenType.EQUALS);
            String value = this.matches(TokenType.TOKEN) ? this.token() : this.quotedString();
            return new Parameter(name, value);
        }

        private String token() {
            return this.expectAndAdvance((TokenType)TokenType.TOKEN).lexeme;
        }

        private String quotedString() {
            return this.expectAndAdvance((TokenType)TokenType.QUOTED_STRING).lexeme;
        }

        private boolean matches(TokenType type) {
            return this.lexer.peek().type == type;
        }

        private boolean mismatches(TokenType type) {
            return this.lexer.peek().type != type;
        }

        private boolean eof() {
            return this.matches(TokenType.EOF);
        }

        private boolean matchAndAdvance(TokenType type) {
            if (this.matches(type)) {
                this.lexer.advance();
                return true;
            }
            return false;
        }

        private void skipWs() {
            while (this.matches(TokenType.WS)) {
                this.lexer.advance();
            }
        }

        private Token advance() {
            Token ret = this.lexer.peek();
            this.lexer.advance();
            return ret;
        }

        private Token expectAndAdvance(TokenType expectedType) {
            if (this.mismatches(expectedType)) {
                throw new IllegalArgumentException("Expected token of type %s, got %s".formatted(new Object[]{expectedType, this.lexer.peek().type}));
            }
            return this.advance();
        }
    }

    private static class Lexer {
        private static final Token WS_TOKEN = Token.of(TokenType.WS, " ");
        private static final Token COMMA_TOKEN = Token.of(TokenType.COMMA, ",");
        private static final Token SEMICOLON_TOKEN = Token.of(TokenType.SEMICOLON, ";");
        private static final Token FWD_SLASH_TOKEN = Token.of(TokenType.FWD_SLASH, "/");
        private static final Token EQUALS_TOKEN = Token.of(TokenType.EQUALS, "=");
        private static final Token EOF_TOKEN = Token.of(TokenType.EOF);
        private int tokStart = 0;
        private int curIndex = 0;
        private final String input;
        private final int len;
        private Token curToken;

        Lexer(String input) {
            this.input = input;
            this.len = input.length();
            this.advance();
        }

        void advance() {
            this.tokStart = this.curIndex;
            if (this.atEnd()) {
                this.curToken = EOF_TOKEN;
                return;
            }
            char ch = this.advanceChar();
            this.curToken = switch (ch) {
                case '\t', ' ' -> WS_TOKEN;
                case '\"' -> this.lexQuotedString();
                case ',' -> COMMA_TOKEN;
                case ';' -> SEMICOLON_TOKEN;
                case '/' -> FWD_SLASH_TOKEN;
                case '=' -> EQUALS_TOKEN;
                default -> {
                    if (Lexer.isTokenChar(ch)) {
                        yield this.lexToken();
                    }
                    throw new IllegalArgumentException("failed to lex next token at index %d".formatted(this.tokStart));
                }
            };
        }

        private static boolean isTokenChar(char ch) {
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || "!#$%&'*+-.^_`|~".indexOf(ch) != -1;
        }

        private Token lexToken() {
            while (!this.atEnd() && Lexer.isTokenChar(this.input.charAt(this.curIndex))) {
                ++this.curIndex;
            }
            return Token.of(TokenType.TOKEN, this.input.substring(this.tokStart, this.curIndex));
        }

        private Token lexQuotedString() {
            while (!this.atEnd()) {
                char ch = this.advanceChar();
                if (ch == '\"') {
                    return Token.of(TokenType.QUOTED_STRING, this.input.substring(this.tokStart, this.curIndex));
                }
                if (ch != '\\') continue;
                if (this.atEnd()) {
                    throw new IllegalArgumentException("incomplete character escape sequence");
                }
                ++this.curIndex;
            }
            throw new IllegalArgumentException("quoted string not terminated");
        }

        private boolean atEnd() {
            return this.curIndex == this.len;
        }

        private char advanceChar() {
            char ch = this.input.charAt(this.curIndex);
            ++this.curIndex;
            return ch;
        }

        Token peek() {
            return this.curToken;
        }
    }

    private record RankedMediaType(String type, double quality, int rank) implements Comparable<RankedMediaType>
    {
        @Override
        public int compareTo(RankedMediaType rhs) {
            int qualityCmp = Double.compare(rhs.quality, this.quality);
            if (qualityCmp != 0) {
                return qualityCmp;
            }
            return Integer.compare(this.rank, rhs.rank);
        }
    }

    private record MediaRange(MediaType mediaType, Parameters parameters, double quality) {
    }

    private record MediaType(String type, String subtype, String cachedFullType) {
    }

    private record Token(TokenType type, String lexeme) {
        static Token of(TokenType type, String lexeme) {
            return new Token(type, lexeme);
        }

        static Token of(TokenType type) {
            return new Token(type, "");
        }
    }

    private static enum TokenType {
        TOKEN,
        WS,
        QUOTED_STRING,
        COMMA,
        FWD_SLASH,
        SEMICOLON,
        EQUALS,
        EOF;

    }

    private record Parameters(List<Parameter> params) {
    }

    private record Parameter(String key, String value) {
    }
}

