/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.restapi.resource.JsonNames;
import com.yahoo.document.restapi.resource.ResponseWriter;
import com.yahoo.document.restapi.resource.StreamableJsonResponse;
import com.yahoo.document.restapi.resource.TraceJsonRenderer;
import com.yahoo.document.restapi.resource.VisitorContinuation;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.tensor.serialization.JsonFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

class StreamingJsonLinesResponse
implements StreamableJsonResponse {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).rootValueSeparator((String)null).build();
    private static final int DEFAULT_STREAM_ALLOC_SIZE = 32;
    private final ResponseWriter responseWriter;
    private final JsonFormat.EncodeOptions tensorOptions;
    private final Object lock = new Object();
    private VisitorContinuation pendingContinuation = null;

    public StreamingJsonLinesResponse(ResponseWriter responseWriter, JsonFormat.EncodeOptions tensorOptions) {
        this.responseWriter = responseWriter;
        this.tensorOptions = tensorOptions;
    }

    @Override
    public void commit(int status, boolean fullyApplied) throws IOException {
        this.responseWriter.commit(status, "application/jsonl; charset=UTF-8", fullyApplied);
    }

    @Override
    public void writeDocumentsArrayStart() throws IOException {
    }

    @Override
    public void writeDocumentsArrayEnd() throws IOException {
    }

    private void writeJsonLine(MyJsonWriter jsonWriter, CompletionHandler completionHandler) throws IOException {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream(32);
        try (JsonGenerator json = JSON_FACTORY.createGenerator((OutputStream)myOut);){
            jsonWriter.writeInto(json);
            json.writeRaw('\n');
        }
        this.responseWriter.write(ByteBuffer.wrap(myOut.toByteArray()), completionHandler);
    }

    private void writeJsonLine(MyJsonWriter jsonWriter) throws IOException {
        this.writeJsonLine(jsonWriter, null);
    }

    @Override
    public void writeDocumentValue(Document document, CompletionHandler completionHandler) throws IOException {
        this.writeJsonLine(json -> {
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.PUT);
            json.writeString(document.getId().toString());
            new JsonWriter(json, this.tensorOptions).writeFields(document);
            json.writeEndObject();
            this.appendUpdatedContinuationLineIfPresent(json);
        }, completionHandler);
    }

    @Override
    public void writeDocumentRemoval(DocumentId id, CompletionHandler completionHandler) throws IOException {
        this.writeJsonLine(json -> {
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.REMOVE);
            json.writeString(id.toString());
            json.writeEndObject();
            this.appendUpdatedContinuationLineIfPresent(json);
        }, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportUpdatedContinuation(Supplier<VisitorContinuation> continuationSupplier) throws IOException {
        VisitorContinuation continuation = continuationSupplier.get();
        Object object = this.lock;
        synchronized (object) {
            this.pendingContinuation = continuation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendUpdatedContinuationLineIfPresent(JsonGenerator json) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingContinuation != null) {
                json.writeRaw('\n');
                this.appendContinuationToken(json, this.pendingContinuation);
                this.pendingContinuation = null;
            }
        }
    }

    private void appendContinuationToken(JsonGenerator json, VisitorContinuation continuation) throws IOException {
        json.writeStartObject();
        json.writeFieldName((SerializableString)JsonNames.CONTINUATION);
        json.writeStartObject();
        if (continuation.hasRemaining()) {
            json.writeFieldName((SerializableString)JsonNames.TOKEN);
            json.writeString(continuation.token());
        }
        json.writeFieldName((SerializableString)JsonNames.PERCENT_FINISHED);
        json.writeNumber(continuation.percentFinished());
        json.writeEndObject();
        json.writeEndObject();
    }

    @Override
    public void writeEpilogueContinuation(VisitorContinuation continuation) throws IOException {
        this.writeJsonLine(json -> this.appendContinuationToken(json, continuation));
    }

    @Override
    public void writeTrace(Trace trace) throws IOException {
        if (trace == null || trace.getRoot().isEmpty()) {
            return;
        }
        this.writeJsonLine(json -> {
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.TRACE);
            json.writeStartObject();
            TraceJsonRenderer.writeTrace(json, trace.getRoot());
            json.writeEndObject();
            json.writeEndObject();
        });
    }

    @Override
    public void writeMessage(String message, StreamableJsonResponse.MessageSeverity severity) throws IOException {
        this.writeJsonLine(json -> {
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.MESSAGE);
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.TEXT);
            json.writeString(message);
            json.writeFieldName((SerializableString)JsonNames.SEVERITY);
            json.writeString(severity.jsonValue());
            json.writeEndObject();
            json.writeEndObject();
        });
    }

    @Override
    public void writeDocumentCount(long count) throws IOException {
        this.writeJsonLine(json -> {
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.SESSION_STATS);
            json.writeStartObject();
            json.writeFieldName((SerializableString)JsonNames.DOCUMENT_COUNT);
            json.writeNumber(count);
            json.writeEndObject();
            json.writeEndObject();
        });
    }

    @Override
    public void close() throws IOException {
        this.responseWriter.close();
    }

    @FunctionalInterface
    static interface MyJsonWriter {
        public void writeInto(JsonGenerator var1) throws IOException;
    }
}

