/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.restapi.resource.DocumentPath;
import com.yahoo.document.restapi.resource.JsonNames;
import com.yahoo.document.restapi.resource.StreamableJsonResponse;
import com.yahoo.document.restapi.resource.TraceJsonRenderer;
import com.yahoo.document.restapi.resource.VisitorContinuation;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.messagebus.Trace;
import com.yahoo.tensor.serialization.JsonFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class JsonResponse
implements StreamableJsonResponse {
    private static final Logger log = Logger.getLogger(JsonResponse.class.getName());
    private static final ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
    private static final int FLUSH_SIZE = 128;
    private static final CompletionHandler logException = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, "Exception writing or closing response data", t);
        }
    };
    private static final JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();
    private final BufferedContentChannel buffer = new BufferedContentChannel();
    private final OutputStream out = new ContentChannelOutputStream((ContentChannel)this.buffer);
    private final JsonGenerator json;
    private final ResponseHandler handler;
    private final Queue<CompletionHandler> acks = new ConcurrentLinkedQueue<CompletionHandler>();
    private final Queue<ByteArrayOutputStream> docs = new ConcurrentLinkedQueue<ByteArrayOutputStream>();
    private final AtomicLong documentsWritten = new AtomicLong();
    private final AtomicLong documentsFlushed = new AtomicLong();
    private final AtomicLong documentsAcked = new AtomicLong();
    private final JsonFormat.EncodeOptions tensorOptions;
    private boolean documentsDone = false;
    private boolean first = true;
    private ContentChannel channel;

    private JsonResponse(ResponseHandler handler, JsonFormat.EncodeOptions tensorOptions) throws IOException {
        this.handler = handler;
        this.tensorOptions = tensorOptions;
        this.json = jsonFactory.createGenerator(this.out);
        this.json.writeStartObject();
    }

    static JsonResponse createWithPathAndId(DocumentPath path, ResponseHandler handler, JsonFormat.EncodeOptions tensorOptions) throws IOException {
        JsonResponse response = new JsonResponse(handler, tensorOptions);
        response.writePathId(path.rawPath());
        response.writeDocId(path.id());
        return response;
    }

    static JsonResponse createWithPath(HttpRequest request, ResponseHandler handler, JsonFormat.EncodeOptions tensorOptions) throws IOException {
        JsonResponse response = new JsonResponse(handler, tensorOptions);
        response.writePathId(request.getUri().getRawPath());
        return response;
    }

    static JsonResponse createWithPathAndMessage(HttpRequest request, String message, ResponseHandler handler, JsonFormat.EncodeOptions tensorOptions) throws IOException {
        JsonResponse response = JsonResponse.createWithPath(request, handler, tensorOptions);
        response.writeMessage(message);
        return response;
    }

    synchronized void commit(int status) throws IOException {
        this.commit(status, true);
    }

    @Override
    public synchronized void commit(int status, boolean fullyApplied) throws IOException {
        Response response = new Response(status);
        response.headers().add("Content-Type", List.of("application/json; charset=UTF-8"));
        if (!fullyApplied) {
            response.headers().add("X-Vespa-Ignored-Fields", "true");
        }
        try {
            this.channel = this.handler.handleResponse(response);
            this.buffer.connectTo(this.channel);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    synchronized void respond(int status) throws IOException {
        try (JsonResponse jsonResponse = this;){
            this.commit(status);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.documentsDone = true;
        try {
            if (this.channel == null) {
                log.log(Level.WARNING, "Close called before response was committed");
                this.commit(500);
            }
            this.json.close();
            this.out.close();
        }
        finally {
            if (this.channel != null) {
                this.channel.close(logException);
            }
        }
    }

    synchronized void writePathId(String path) throws IOException {
        this.json.writeFieldName((SerializableString)JsonNames.PATH_ID);
        this.json.writeString(path);
    }

    @Override
    public synchronized void writeMessage(String message) throws IOException {
        this.json.writeFieldName((SerializableString)JsonNames.MESSAGE);
        this.json.writeString(message);
    }

    @Override
    public synchronized void writeDocumentCount(long count) throws IOException {
        this.json.writeFieldName((SerializableString)JsonNames.DOCUMENT_COUNT);
        this.json.writeNumber(count);
    }

    synchronized void writeDocId(DocumentId id) throws IOException {
        this.json.writeFieldName((SerializableString)JsonNames.ID);
        this.json.writeString(id.toString());
    }

    @Override
    public synchronized void writeTrace(Trace trace) throws IOException {
        if (trace != null && !trace.getRoot().isEmpty()) {
            TraceJsonRenderer.writeTrace(this.json, trace.getRoot());
        }
    }

    private JsonFormat.EncodeOptions tensorOptions() {
        return this.tensorOptions;
    }

    private boolean tensorShortForm() {
        return this.tensorOptions().shortForm();
    }

    private boolean tensorDirectValues() {
        return this.tensorOptions().directValues();
    }

    synchronized void writeSingleDocument(Document document) throws IOException {
        new JsonWriter(this.json, this.tensorOptions()).writeFields(document);
    }

    @Override
    public synchronized void writeDocumentsArrayStart() throws IOException {
        this.json.writeFieldName((SerializableString)JsonNames.DOCUMENTS);
        this.json.writeStartArray();
    }

    @Override
    public void writeDocumentValue(Document document, CompletionHandler completionHandler) throws IOException {
        this.writeDocument(myOut -> {
            try (JsonGenerator myJson = jsonFactory.createGenerator((OutputStream)myOut);){
                new JsonWriter(myJson, this.tensorShortForm(), this.tensorDirectValues()).write(document);
            }
        }, completionHandler);
    }

    @Override
    public void writeDocumentRemoval(DocumentId id, CompletionHandler completionHandler) throws IOException {
        this.writeDocument(myOut -> {
            try (JsonGenerator myJson = jsonFactory.createGenerator((OutputStream)myOut);){
                myJson.writeStartObject();
                myJson.writeFieldName((SerializableString)JsonNames.REMOVE);
                myJson.writeString(id.toString());
                myJson.writeEndObject();
            }
        }, completionHandler);
    }

    void writeDocument(DocumentWriter documentWriter, CompletionHandler completionHandler) throws IOException {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream(1);
        myOut.write(44);
        documentWriter.write(myOut);
        this.docs.add(myOut);
        if (completionHandler != null) {
            this.acks.add(completionHandler);
            this.ackDocuments();
        }
        if (this.documentsWritten.incrementAndGet() % 128L == 0L) {
            this.flushDocuments();
        }
    }

    void ackDocuments() {
        CompletionHandler ack;
        while (this.documentsAcked.incrementAndGet() <= this.documentsFlushed.get() + 128L && (ack = this.acks.poll()) != null) {
            ack.completed();
        }
        this.documentsAcked.decrementAndGet();
    }

    synchronized void flushDocuments() throws IOException {
        ByteArrayOutputStream doc;
        for (int i = 0; i < 128 && (doc = this.docs.poll()) != null; ++i) {
            if (this.documentsDone) continue;
            if (this.first) {
                this.json.flush();
                this.buffer.write(ByteBuffer.wrap(doc.toByteArray(), 1, doc.size() - 1), null);
                this.first = false;
                continue;
            }
            this.buffer.write(ByteBuffer.wrap(doc.toByteArray()), null);
        }
        this.buffer.write(emptyBuffer, new CompletionHandler(){

            public void completed() {
                JsonResponse.this.documentsFlushed.addAndGet(128L);
                JsonResponse.this.ackDocuments();
            }

            public void failed(Throwable t) {
                log.log(Level.FINE, "Error writing documents", t);
                this.completed();
            }
        });
    }

    @Override
    public synchronized void writeDocumentsArrayEnd() throws IOException {
        this.flushDocuments();
        this.documentsDone = true;
        this.json.writeEndArray();
    }

    @Override
    public void reportUpdatedContinuation(Supplier<VisitorContinuation> continuationSupplier) throws IOException {
    }

    @Override
    public synchronized void writeEpilogueContinuation(VisitorContinuation continuation) throws IOException {
        if (continuation.hasRemaining()) {
            this.json.writeFieldName((SerializableString)JsonNames.CONTINUATION);
            this.json.writeString(continuation.token());
        }
    }

    @FunctionalInterface
    private static interface DocumentWriter {
        public void write(ByteArrayOutputStream var1) throws IOException;
    }
}

