/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.jdisc.Metric;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.vespa.http.server.ErrorCode;
import com.yahoo.vespa.http.server.MetricNames;
import com.yahoo.vespa.http.server.OperationStatus;
import com.yahoo.vespa.http.server.ReplyContext;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeedReplyReader
implements ReplyHandler {
    private static final Logger log = Logger.getLogger(FeedReplyReader.class.getName());
    private final Metric metric;
    private final DocumentApiMetrics metricsHelper;
    private final Metric.Context testAndSetMetricCtx;

    public FeedReplyReader(Metric metric, DocumentApiMetrics metricsHelper) {
        this.metric = metric;
        this.metricsHelper = metricsHelper;
        this.testAndSetMetricCtx = metric.createContext(Map.of("operationType", "testAndSet"));
    }

    public void handleReply(Reply reply) {
        Object o = reply.getContext();
        if (!(o instanceof ReplyContext)) {
            return;
        }
        ReplyContext context = (ReplyContext)o;
        double latencyInSeconds = (double)(System.currentTimeMillis() - context.creationTime) / 1000.0;
        this.metric.set(MetricNames.LATENCY, (Number)latencyInSeconds, null);
        DocumentOperationType type = DocumentOperationType.fromMessage(reply.getMessage());
        boolean conditionMet = FeedReplyReader.conditionMet(reply);
        if (reply.hasErrors() && conditionMet) {
            DocumentOperationStatus status = DocumentOperationStatus.fromMessageBusErrorCodes(reply.getErrorCodes());
            this.metricsHelper.reportFailure(type, status);
            this.metric.add(MetricNames.FAILED, (Number)1, null);
            this.enqueue(context, reply.getError(0).getMessage(), ErrorCode.fromBusError(reply.getError(0)), false, reply.getTrace());
        } else {
            this.metricsHelper.reportSuccessful(type, latencyInSeconds);
            if (!conditionMet) {
                this.metric.add(MetricNames.CONDITION_NOT_MET, (Number)1, this.testAndSetMetricCtx);
            } else if (!FeedReplyReader.updateNotFound(reply)) {
                this.metric.add(MetricNames.NOT_FOUND, (Number)1, null);
            } else {
                this.metric.add(MetricNames.SUCCEEDED, (Number)1, null);
            }
            this.enqueue(context, "Document processed.", ErrorCode.OK, !conditionMet, reply.getTrace());
        }
    }

    private static boolean conditionMet(Reply reply) {
        return !reply.hasErrors() || reply.getError(0).getCode() != 251013;
    }

    private static boolean updateNotFound(Reply reply) {
        return reply instanceof UpdateDocumentReply && !((UpdateDocumentReply)reply).wasFound() && reply.getMessage() instanceof UpdateDocumentMessage && ((UpdateDocumentMessage)reply.getMessage()).getDocumentUpdate() != null && !((UpdateDocumentMessage)reply.getMessage()).getDocumentUpdate().getCreateIfNonExistent();
    }

    private void enqueue(ReplyContext context, String message, ErrorCode status, boolean isConditionNotMet, Trace trace) {
        try {
            String traceMessage = trace != null && trace.getLevel() > 0 ? trace.toString() : "";
            context.feedReplies.put(new OperationStatus(message, context.docId, status, isConditionNotMet, traceMessage));
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted while enqueueing result from putting document with id: " + context.docId);
            Thread.currentThread().interrupt();
        }
    }
}

