/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.server;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.vespa.http.client.config.FeedParams;
import java.util.Optional;

public class FeederSettings {
    private static final Route DEFAULT_ROUTE = Route.parse((String)"default");
    public final boolean drain;
    public final Route route;
    public final boolean denyIfBusy;
    public final FeedParams.DataFormat dataFormat;
    public final String priority;
    public final Integer traceLevel;

    public FeederSettings(HttpRequest request) {
        this.drain = Optional.ofNullable(request.getHeader("X-Yahoo-Feed-Drain")).map(Boolean::parseBoolean).orElse(false);
        this.route = Optional.ofNullable(request.getHeader("X-Yahoo-Feed-Route")).map(Route::parse).orElse(DEFAULT_ROUTE);
        this.denyIfBusy = Optional.ofNullable(request.getHeader("X-Yahoo-Feed-Deny-If-Busy")).map(Boolean::parseBoolean).orElse(false);
        this.dataFormat = Optional.ofNullable(request.getHeader("X-Yahoo-Feed-Data-Format")).map(FeedParams.DataFormat::valueOf).orElse(FeedParams.DataFormat.XML_UTF8);
        this.priority = request.getHeader("X-Yahoo-Feed-Priority");
        this.traceLevel = Optional.ofNullable(request.getHeader("X-Yahoo-Feed-Trace-Level")).map(Integer::valueOf).orElse(null);
    }
}

