/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.documentapi.DumpVisitorDataHandler;
import com.yahoo.exception.ExceptionUtils;
import java.nio.charset.StandardCharsets;

class LocalDataVisitorHandler
extends DumpVisitorDataHandler {
    StringBuilder commaSeparatedJsonDocuments = new StringBuilder();
    final StringBuilder errors = new StringBuilder();
    private boolean isFirst = true;
    private final Object monitor = new Object();

    LocalDataVisitorHandler() {
    }

    String getErrors() {
        return this.errors.toString();
    }

    String getCommaSeparatedJsonDocuments() {
        return this.commaSeparatedJsonDocuments.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDocument(Document document, long l) {
        try {
            String docJson = new String(JsonWriter.toByteArray((Document)document), StandardCharsets.UTF_8.name());
            Object object = this.monitor;
            synchronized (object) {
                if (!this.isFirst) {
                    this.commaSeparatedJsonDocuments.append(",");
                }
                this.isFirst = false;
                this.commaSeparatedJsonDocuments.append(docJson);
            }
        }
        catch (Exception e) {
            Object object = this.monitor;
            synchronized (object) {
                this.errors.append(ExceptionUtils.getStackTraceAsString((Throwable)e)).append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(DocumentId documentId) {
        try {
            String removeJson = new String(JsonWriter.documentRemove((DocumentId)documentId), StandardCharsets.UTF_8.name());
            Object object = this.monitor;
            synchronized (object) {
                if (!this.isFirst) {
                    this.commaSeparatedJsonDocuments.append(",");
                }
                this.isFirst = false;
                this.commaSeparatedJsonDocuments.append(removeJson);
            }
        }
        catch (Exception e) {
            Object object = this.monitor;
            synchronized (object) {
                this.errors.append(ExceptionUtils.getStackTraceAsString((Throwable)e)).append("\n");
            }
        }
    }
}

