/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.restapi.LocalDataVisitorHandler;
import com.yahoo.document.restapi.OperationHandler;
import com.yahoo.document.restapi.Response;
import com.yahoo.document.restapi.RestApiException;
import com.yahoo.document.restapi.RestUri;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessException;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorControlSession;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.messagebus.MessageBusSyncSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.metrics.DocumentApiMetrics;
import com.yahoo.documentapi.metrics.DocumentOperationStatus;
import com.yahoo.documentapi.metrics.DocumentOperationType;
import com.yahoo.exception.ExceptionUtils;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.vespaclient.ClusterDef;
import com.yahoo.vespaxmlparser.FeedOperation;
import com.yahoo.yolean.concurrent.ConcurrentResourcePool;
import com.yahoo.yolean.concurrent.ResourceFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OperationHandlerImpl
implements OperationHandler {
    public static final int VISIT_TIMEOUT_MS = 120000;
    public static final int WANTED_DOCUMENT_COUNT_UPPER_BOUND = 1000;
    private final DocumentAccess documentAccess;
    private final DocumentApiMetrics metricsHelper;
    private final ClusterEnumerator clusterEnumerator;
    private final BucketSpaceResolver bucketSpaceResolver;
    private final ConcurrentResourcePool<SyncSession> syncSessions;
    private static final int HTTP_STATUS_BAD_REQUEST = 400;
    private static final int HTTP_STATUS_INSUFFICIENT_STORAGE = 507;
    private static final int HTTP_PRE_CONDIDTION_FAILED = 412;

    public OperationHandlerImpl(DocumentAccess documentAccess, ClusterEnumerator clusterEnumerator, BucketSpaceResolver bucketSpaceResolver, MetricReceiver metricReceiver) {
        this.documentAccess = documentAccess;
        this.clusterEnumerator = clusterEnumerator;
        this.bucketSpaceResolver = bucketSpaceResolver;
        this.syncSessions = new ConcurrentResourcePool((ResourceFactory)new SyncSessionFactory(documentAccess));
        this.metricsHelper = new DocumentApiMetrics(metricReceiver, "documentV1");
    }

    @Override
    public void shutdown() {
        for (SyncSession session : this.syncSessions) {
            session.destroy();
        }
        this.documentAccess.shutdown();
    }

    public static int getHTTPStatusCode(Set<Integer> errorCodes) {
        if (errorCodes.size() == 1 && errorCodes.contains(251009)) {
            return 507;
        }
        if (errorCodes.contains(251013)) {
            return 412;
        }
        return 400;
    }

    private static Response createErrorResponse(DocumentAccessException documentException, RestUri restUri) {
        if (documentException.hasConditionNotMetError()) {
            return Response.createErrorResponse(OperationHandlerImpl.getHTTPStatusCode(documentException.getErrorCodes()), "Condition did not match document.", restUri, RestUri.apiErrorCodes.DOCUMENT_CONDITION_NOT_MET);
        }
        return Response.createErrorResponse(OperationHandlerImpl.getHTTPStatusCode(documentException.getErrorCodes()), documentException.getMessage(), restUri, RestUri.apiErrorCodes.DOCUMENT_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandler.VisitResult visit(RestUri restUri, String documentSelection, OperationHandler.VisitOptions options) throws RestApiException {
        VisitorSession visitorSession;
        VisitorParameters visitorParameters = this.createVisitorParameters(restUri, documentSelection, options);
        VisitorControlHandler visitorControlHandler = new VisitorControlHandler();
        visitorParameters.setControlHandler(visitorControlHandler);
        LocalDataVisitorHandler localDataVisitorHandler = new LocalDataVisitorHandler();
        visitorParameters.setLocalDataHandler((VisitorDataHandler)localDataVisitorHandler);
        try {
            visitorSession = this.documentAccess.createVisitorSession(visitorParameters);
            visitorControlHandler.setSession((VisitorControlSession)visitorSession);
        }
        catch (Exception e) {
            throw new RestApiException(Response.createErrorResponse(500, "Failed during parsing of arguments for visiting: " + ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.VISITOR_ERROR));
        }
        try {
            OperationHandler.VisitResult visitResult = this.doVisit(visitorControlHandler, localDataVisitorHandler, restUri);
            return visitResult;
        }
        finally {
            visitorSession.destroy();
        }
    }

    private static void throwIfFatalVisitingError(VisitorControlHandler handler, RestUri restUri) throws RestApiException {
        VisitorControlHandler.Result result = handler.getResult();
        if (result.getCode() == VisitorControlHandler.CompletionCode.TIMEOUT) {
            if (!handler.hasVisitedAnyBuckets()) {
                throw new RestApiException(Response.createErrorResponse(500, "Timed out", restUri, RestUri.apiErrorCodes.TIME_OUT));
            }
        } else if (result.getCode() != VisitorControlHandler.CompletionCode.SUCCESS) {
            throw new RestApiException(Response.createErrorResponse(400, result.toString(), RestUri.apiErrorCodes.VISITOR_ERROR));
        }
    }

    private OperationHandler.VisitResult doVisit(VisitorControlHandler visitorControlHandler, LocalDataVisitorHandler localDataVisitorHandler, RestUri restUri) throws RestApiException {
        try {
            visitorControlHandler.waitUntilDone();
            OperationHandlerImpl.throwIfFatalVisitingError(visitorControlHandler, restUri);
        }
        catch (InterruptedException e) {
            throw new RestApiException(Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.INTERRUPTED));
        }
        if (localDataVisitorHandler.getErrors().isEmpty()) {
            Optional<String> continuationToken = !visitorControlHandler.getProgress().isFinished() ? Optional.of(visitorControlHandler.getProgress().serializeToString()) : Optional.empty();
            return new OperationHandler.VisitResult(continuationToken, localDataVisitorHandler.getCommaSeparatedJsonDocuments());
        }
        throw new RestApiException(Response.createErrorResponse(500, localDataVisitorHandler.getErrors(), restUri, RestUri.apiErrorCodes.UNSPECIFIED));
    }

    private void setRoute(SyncSession session, Optional<String> route) throws RestApiException {
        if (!(session instanceof MessageBusSyncSession)) {
            throw new RestApiException(Response.createErrorResponse(400, "Can not set route since the API is not using message bus.", RestUri.apiErrorCodes.NO_ROUTE_WHEN_NOT_PART_OF_MESSAGEBUS));
        }
        ((MessageBusSyncSession)session).setRoute(route.orElse("default"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RestUri restUri, FeedOperation data, Optional<String> route) throws RestApiException {
        Response response;
        SyncSession syncSession = (SyncSession)this.syncSessions.alloc();
        try {
            Instant startTime = Instant.now();
            DocumentPut put = new DocumentPut(data.getDocument());
            put.setCondition(data.getCondition());
            this.setRoute(syncSession, route);
            syncSession.put(put);
            this.metricsHelper.reportSuccessful(DocumentOperationType.PUT, startTime);
            return;
        }
        catch (DocumentAccessException documentException) {
            response = OperationHandlerImpl.createErrorResponse(documentException, restUri);
        }
        catch (Exception e) {
            response = Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.INTERNAL_EXCEPTION);
        }
        finally {
            this.syncSessions.free((Object)syncSession);
        }
        this.metricsHelper.reportFailure(DocumentOperationType.PUT, DocumentOperationStatus.fromHttpStatusCode(response.getStatus()));
        throw new RestApiException(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RestUri restUri, FeedOperation data, Optional<String> route) throws RestApiException {
        Response response;
        SyncSession syncSession = (SyncSession)this.syncSessions.alloc();
        try {
            Instant startTime = Instant.now();
            this.setRoute(syncSession, route);
            syncSession.update(data.getDocumentUpdate());
            this.metricsHelper.reportSuccessful(DocumentOperationType.UPDATE, startTime);
            return;
        }
        catch (DocumentAccessException documentException) {
            response = OperationHandlerImpl.createErrorResponse(documentException, restUri);
        }
        catch (Exception e) {
            response = Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.INTERNAL_EXCEPTION);
        }
        finally {
            this.syncSessions.free((Object)syncSession);
        }
        this.metricsHelper.reportFailure(DocumentOperationType.UPDATE, DocumentOperationStatus.fromHttpStatusCode(response.getStatus()));
        throw new RestApiException(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(RestUri restUri, String condition, Optional<String> route) throws RestApiException {
        Response response;
        SyncSession syncSession = (SyncSession)this.syncSessions.alloc();
        try {
            Instant startTime = Instant.now();
            DocumentId id = new DocumentId(restUri.generateFullId());
            DocumentRemove documentRemove = new DocumentRemove(id);
            this.setRoute(syncSession, route);
            if (condition != null && !condition.isEmpty()) {
                documentRemove.setCondition(new TestAndSetCondition(condition));
            }
            syncSession.remove(documentRemove);
            this.metricsHelper.reportSuccessful(DocumentOperationType.REMOVE, startTime);
            return;
        }
        catch (DocumentAccessException documentException) {
            response = documentException.hasConditionNotMetError() ? Response.createErrorResponse(412, "Condition not met: " + documentException.getMessage(), restUri, RestUri.apiErrorCodes.DOCUMENT_CONDITION_NOT_MET) : Response.createErrorResponse(400, documentException.getMessage(), restUri, RestUri.apiErrorCodes.DOCUMENT_EXCEPTION);
        }
        catch (Exception e) {
            response = Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.UNSPECIFIED);
        }
        finally {
            this.syncSessions.free((Object)syncSession);
        }
        this.metricsHelper.reportFailure(DocumentOperationType.REMOVE, DocumentOperationStatus.fromHttpStatusCode(response.getStatus()));
        throw new RestApiException(response);
    }

    @Override
    public Optional<String> get(RestUri restUri, Optional<String> fieldSet, Optional<String> cluster) throws RestApiException {
        SyncSession syncSession = (SyncSession)this.syncSessions.alloc();
        Optional<String> route = cluster.isPresent() ? Optional.of(OperationHandlerImpl.clusterDefToRoute(OperationHandlerImpl.resolveClusterDef(cluster, this.clusterEnumerator.enumerateClusters()))) : Optional.empty();
        this.setRoute(syncSession, route);
        try {
            DocumentId id = new DocumentId(restUri.generateFullId());
            Document document = syncSession.get(id, fieldSet.orElse(restUri.getDocumentType() + ":[document]"), DocumentProtocol.Priority.NORMAL_1);
            if (document == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonWriter jsonWriter = new JsonWriter((OutputStream)outputStream);
            jsonWriter.write(document);
            Optional<String> optional = Optional.of(outputStream.toString(StandardCharsets.UTF_8.name()));
            return optional;
        }
        catch (Exception e) {
            throw new RestApiException(Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.UNSPECIFIED));
        }
        finally {
            this.syncSessions.free((Object)syncSession);
        }
    }

    @Override
    public Optional<String> get(RestUri restUri, Optional<String> fieldSet) throws RestApiException {
        return this.get(restUri, fieldSet, Optional.empty());
    }

    @Override
    public Optional<String> get(RestUri restUri) throws RestApiException {
        return this.get(restUri, Optional.empty());
    }

    private static boolean isValidBucketSpace(String spaceName) {
        return FixedBucketSpaces.defaultSpace().equals(spaceName) || FixedBucketSpaces.globalSpace().equals(spaceName);
    }

    protected BucketSpaceRoute resolveBucketSpaceRoute(Optional<String> wantedCluster, Optional<String> wantedBucketSpace, RestUri restUri) throws RestApiException {
        String targetBucketSpace;
        List<ClusterDef> clusters = this.clusterEnumerator.enumerateClusters();
        ClusterDef clusterDef = OperationHandlerImpl.resolveClusterDef(wantedCluster, clusters);
        if (!restUri.isRootOnly()) {
            String docType = restUri.getDocumentType();
            Optional<String> resolvedSpace = this.bucketSpaceResolver.clusterBucketSpaceFromDocumentType(clusterDef.getName(), docType);
            if (!resolvedSpace.isPresent()) {
                throw new RestApiException(Response.createErrorResponse(400, String.format("Document type '%s' in cluster '%s' is not mapped to a known bucket space", docType, clusterDef.getName()), RestUri.apiErrorCodes.UNKNOWN_BUCKET_SPACE));
            }
            targetBucketSpace = resolvedSpace.get();
        } else {
            if (wantedBucketSpace.isPresent() && !OperationHandlerImpl.isValidBucketSpace(wantedBucketSpace.get())) {
                throw new RestApiException(Response.createErrorResponse(400, String.format("Bucket space '%s' is not a known bucket space (expected '%s' or '%s')", wantedBucketSpace.get(), FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace()), RestUri.apiErrorCodes.UNKNOWN_BUCKET_SPACE));
            }
            targetBucketSpace = wantedBucketSpace.orElse(FixedBucketSpaces.defaultSpace());
        }
        return new BucketSpaceRoute(OperationHandlerImpl.clusterDefToRoute(clusterDef), targetBucketSpace);
    }

    protected static ClusterDef resolveClusterDef(Optional<String> wantedCluster, List<ClusterDef> clusters) throws RestApiException {
        if (clusters.size() == 0) {
            throw new IllegalArgumentException("Your Vespa cluster does not have any content clusters declared. Visiting feature is not available.");
        }
        if (!wantedCluster.isPresent()) {
            if (clusters.size() != 1) {
                String message = "Several clusters exist: " + clusters.stream().map(c -> "'" + c.getName() + "'").collect(Collectors.joining(", ")) + ". You must specify one.";
                throw new RestApiException(Response.createErrorResponse(400, message, RestUri.apiErrorCodes.SEVERAL_CLUSTERS));
            }
            return clusters.get(0);
        }
        for (ClusterDef clusterDef : clusters) {
            if (!clusterDef.getName().equals(wantedCluster.get())) continue;
            return clusterDef;
        }
        String message = "Your vespa cluster contains the content clusters " + clusters.stream().map(c -> "'" + c.getName() + "'").collect(Collectors.joining(", ")) + ", not '" + wantedCluster.get() + "'. Please select a valid vespa cluster.";
        throw new RestApiException(Response.createErrorResponse(400, message, RestUri.apiErrorCodes.MISSING_CLUSTER));
    }

    protected static String clusterDefToRoute(ClusterDef clusterDef) {
        return "[Storage:cluster=" + clusterDef.getName() + ";clusterconfigid=" + clusterDef.getConfigId() + "]";
    }

    private static String buildAugmentedDocumentSelection(RestUri restUri, String documentSelection) {
        if (restUri.isRootOnly()) {
            return documentSelection;
        }
        StringBuilder selection = new StringBuilder();
        if (!documentSelection.isEmpty()) {
            selection.append("((").append(documentSelection).append(") and ");
        }
        selection.append(restUri.getDocumentType()).append(" and (id.namespace=='").append(restUri.getNamespace()).append("')");
        if (!documentSelection.isEmpty()) {
            selection.append(")");
        }
        return selection.toString();
    }

    private VisitorParameters createVisitorParameters(RestUri restUri, String documentSelection, OperationHandler.VisitOptions options) throws RestApiException {
        if (restUri.isRootOnly() && !options.cluster.isPresent()) {
            throw new RestApiException(Response.createErrorResponse(400, "Must set 'cluster' parameter to a valid content cluster id when visiting at a root /document/v1/ level", RestUri.apiErrorCodes.MISSING_CLUSTER));
        }
        String augmentedSelection = OperationHandlerImpl.buildAugmentedDocumentSelection(restUri, documentSelection);
        VisitorParameters params = new VisitorParameters(augmentedSelection);
        params.fieldSet(options.fieldSet.orElse((String)(restUri.isRootOnly() ? "[all]" : restUri.getDocumentType() + ":[document]")));
        params.setMaxBucketsPerVisitor(1);
        params.setMaxPending(32);
        params.setMaxFirstPassHits(1L);
        params.setMaxTotalHits((long)options.wantedDocumentCount.map(n -> Math.min(Math.max(n, 1), 1000)).orElse(1).intValue());
        params.setThrottlePolicy((ThrottlePolicy)new StaticThrottlePolicy().setMaxPendingCount(options.concurrency.orElse(1).intValue()));
        params.setToTimestamp(0L);
        params.setFromTimestamp(0L);
        params.setSessionTimeoutMs(120000L);
        params.visitInconsistentBuckets(true);
        BucketSpaceRoute bucketSpaceRoute = this.resolveBucketSpaceRoute(options.cluster, options.bucketSpace, restUri);
        params.setRoute(bucketSpaceRoute.getClusterRoute());
        params.setBucketSpace(bucketSpaceRoute.getBucketSpace());
        params.setTraceLevel(0);
        params.setPriority(DocumentProtocol.Priority.NORMAL_4);
        params.setVisitRemoves(false);
        if (options.continuation.isPresent()) {
            try {
                params.setResumeToken(ProgressToken.fromSerializedString((String)options.continuation.get()));
            }
            catch (Exception e) {
                throw new RestApiException(Response.createErrorResponse(500, ExceptionUtils.getStackTraceAsString((Throwable)e), restUri, RestUri.apiErrorCodes.UNSPECIFIED));
            }
        }
        return params;
    }

    private static final class SyncSessionFactory
    extends ResourceFactory<SyncSession> {
        private final DocumentAccess documentAccess;

        SyncSessionFactory(DocumentAccess documentAccess) {
            this.documentAccess = documentAccess;
        }

        public SyncSession create() {
            return this.documentAccess.createSyncSession(new SyncParameters.Builder().build());
        }
    }

    public static class BucketSpaceRoute {
        private final String clusterRoute;
        private final String bucketSpace;

        public BucketSpaceRoute(String clusterRoute, String bucketSpace) {
            this.clusterRoute = clusterRoute;
            this.bucketSpace = bucketSpace;
        }

        public String getClusterRoute() {
            return this.clusterRoute;
        }

        public String getBucketSpace() {
            return this.bucketSpace;
        }
    }

    public static interface BucketSpaceResolver {
        public Optional<String> clusterBucketSpaceFromDocumentType(String var1, String var2);
    }

    public static interface ClusterEnumerator {
        public List<ClusterDef> enumerateClusters();
    }
}

