/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.document.restapi.RestUri;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class Response
extends HttpResponse {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final String jsonMessage;

    public Response(int code, Optional<ObjectNode> element, Optional<RestUri> restPath) {
        super(code);
        ObjectNode objectNode = element.orElse(objectMapper.createObjectNode());
        if (restPath.isPresent()) {
            objectNode.put("id", restPath.get().generateFullId());
            objectNode.put("pathId", restPath.get().getRawPath());
        }
        this.jsonMessage = objectNode.toString();
    }

    public static Response createErrorResponse(int code, String errorMessage, RestUri.apiErrorCodes errorID) {
        return Response.createErrorResponse(code, errorMessage, null, errorID);
    }

    public static Response createErrorResponse(int code, String errorMessage, RestUri restUri, RestUri.apiErrorCodes errorID) {
        ObjectNode errorNode = objectMapper.createObjectNode();
        errorNode.put("description", errorID.name() + " " + errorMessage);
        errorNode.put("id", errorID.value);
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.putArray("errors").add((JsonNode)errorNode);
        return new Response(code, Optional.of(objectNode), Optional.ofNullable(restUri));
    }

    public void render(OutputStream stream) throws IOException {
        stream.write(this.jsonMessage.getBytes(StandardCharsets.UTF_8));
    }

    public String getContentType() {
        return "application/json";
    }
}

