/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.storage.searcher;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.Field;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessageProcessor;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.feedapi.SingleSender;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.prelude.templates.UserTemplate;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.Properties;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.storage.searcher.DocumentFieldTemplate;
import com.yahoo.storage.searcher.DocumentHit;
import com.yahoo.storage.searcher.DocumentXMLTemplate;
import com.yahoo.storage.searcher.MessageBusErrorMessage;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespaclient.config.FeederConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class GetSearcher
extends Searcher {
    private static final Logger log = Logger.getLogger(GetSearcher.class.getName());
    private static final CompoundName ID = new CompoundName("id");
    private static final CompoundName HEADERS_ONLY = new CompoundName("headersonly");
    private static final CompoundName POPULATE_HIT_FIELDS = new CompoundName("populatehitfields");
    private static final CompoundName FIELDSET = new CompoundName("fieldset");
    private static final CompoundName FIELD = new CompoundName("field");
    private static final CompoundName CONTENT_TYPE = new CompoundName("contenttype");
    private static final CompoundName TIEMOUT = new CompoundName("timeout");
    FeedContext context;
    private final long defaultTimeoutMillis;
    private static final CompoundName formatShortcut = new CompoundName("format");
    private static final CompoundName format = new CompoundName("presentation.format");

    @Inject
    public GetSearcher(FeederConfig feederConfig, LoadTypeConfig loadTypeConfig, DocumentmanagerConfig documentmanagerConfig, SlobroksConfig slobroksConfig, ClusterListConfig clusterListConfig, Metric metric) throws Exception {
        this(FeedContext.getInstance((FeederConfig)feederConfig, (LoadTypeConfig)loadTypeConfig, (DocumentmanagerConfig)documentmanagerConfig, (SlobroksConfig)slobroksConfig, (ClusterListConfig)clusterListConfig, (Metric)metric), (long)(feederConfig.timeout() * 1000.0));
    }

    GetSearcher(FeedContext context) throws Exception {
        this.context = context;
        this.defaultTimeoutMillis = context.getPropertyProcessor().getDefaultTimeoutMillis();
    }

    GetSearcher(FeedContext context, long defaultTimeoutMillis) throws Exception {
        this.context = context;
        this.defaultTimeoutMillis = defaultTimeoutMillis;
    }

    private static void postValidateDocumentIdParameters(Properties properties, int arrayIdsFound) throws Exception {
        for (Map.Entry kv : properties.listProperties().entrySet()) {
            if (!((String)kv.getKey()).startsWith("id[")) continue;
            if (!((String)kv.getKey()).endsWith("]")) {
                throw new IllegalArgumentException("Malformed document ID array parameter");
            }
            String indexStr = ((String)kv.getKey()).substring(3, ((String)kv.getKey()).length() - 1);
            int idx = Integer.parseInt(indexStr);
            if (idx < arrayIdsFound) continue;
            throw new IllegalArgumentException("query contains document ID array that is not zero-based and/or linearly increasing");
        }
    }

    private List<String> getDocumentIds(Query query) throws Exception {
        Properties properties = query.properties();
        ArrayList<String> docIds = new ArrayList<String>();
        String singleId = properties.getString(ID);
        int index = 0;
        if (singleId != null) {
            docIds.add(singleId);
        } else {
            String docId;
            while ((docId = properties.getString("id[" + index + "]")) != null) {
                docIds.add(docId);
                ++index;
            }
            GetSearcher.postValidateDocumentIdParameters(properties, index);
        }
        this.handleData(query.getHttpRequest(), docIds);
        return docIds;
    }

    private void handleData(HttpRequest request, List<String> docIds) throws IOException {
        if (request.getData() != null) {
            String line;
            InputStream input = "gzip".equals(request.getHeader("Content-Encoding")) ? new GZIPInputStream(request.getData()) : request.getData();
            InputStreamReader reader = new InputStreamReader(input, "UTF-8");
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                docIds.add(line);
            }
        }
    }

    private void handleFieldFiltering(GetResponse response, Result result, String fieldName, String contentType, boolean headersOnly) {
        if (response.getDocumentHits().isEmpty()) {
            result.hits().addError(ErrorMessage.createNotFound((String)("Document not found, could not return field '" + fieldName + "'")));
            return;
        }
        if (result.hits().getErrorHit() == null) {
            Document doc = response.getDocumentHits().get(0).getDocument();
            Field field = doc.getDataType().getField(fieldName);
            boolean wrapXml = false;
            if (field == null) {
                result.hits().addError(ErrorMessage.createIllegalQuery((String)("Field '" + fieldName + "' not found in document type")));
                return;
            }
            FieldValue value = doc.getFieldValue(field);
            if (value == null) {
                if (!field.isHeader() && headersOnly) {
                    result.hits().addError(ErrorMessage.createInvalidQueryParameter((String)("Field '" + fieldName + "' is located in document body, but headersonly prevents it from being retrieved in " + doc.getId().toString())));
                } else {
                    result.hits().addError(ErrorMessage.createNotFound((String)("Field '" + fieldName + "' found in document type, but had no content in " + doc.getId().toString())));
                }
                return;
            }
            String encoding = null;
            if (field.getDataType() == DataType.RAW) {
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                encoding = "ISO-8859-1";
            } else {
                contentType = "text/xml";
                wrapXml = true;
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            response.addHitsToResult(result, false);
            result.getTemplating().setTemplates((UserTemplate)new DocumentFieldTemplate(field, contentType, encoding, wrapXml));
        }
    }

    private void validateParameters(String fieldName, String contentType, List<String> documentIds) {
        if (contentType != null) {
            if (documentIds.size() > 1) {
                throw new IllegalArgumentException("contenttype parameter only valid for single document id query");
            }
            if (fieldName == null) {
                throw new IllegalArgumentException("contenttype set without document field being specified");
            }
        }
        if (fieldName != null && documentIds.size() > 1) {
            throw new IllegalArgumentException("Field only valid for single document id query");
        }
    }

    protected MessagePropertyProcessor getMessagePropertyProcessor() {
        return this.context.getPropertyProcessor();
    }

    private void doGetDocuments(Query query, Result result, List<String> documentIds) {
        long timeoutMillis;
        GetResponse response = new GetResponse(documentIds);
        Properties properties = query.properties();
        boolean headersOnly = properties.getBoolean(HEADERS_ONLY, false);
        boolean populateHitFields = properties.getBoolean(POPULATE_HIT_FIELDS, false);
        String fieldSet = properties.getString(FIELDSET);
        String fieldName = properties.getString(FIELD);
        String contentType = properties.getString(CONTENT_TYPE);
        long l = timeoutMillis = properties.getString(TIEMOUT) != null ? query.getTimeout() : this.defaultTimeoutMillis;
        if (fieldSet == null) {
            fieldSet = headersOnly ? "[header]" : "[all]";
        }
        this.validateParameters(fieldName, contentType, documentIds);
        MessagePropertyProcessor.PropertySetter propertySetter = this.context.getPropertyProcessor().buildPropertySetter(query.getHttpRequest());
        SingleSender sender = new SingleSender((SharedSender.ResultCallback)response, this.context.getSharedSender(propertySetter.getRoute().toString()));
        sender.addMessageProcessor((MessageProcessor)propertySetter);
        this.sendDocumentGetMessages(documentIds, fieldSet, sender);
        sender.done();
        boolean completed = sender.waitForPending(timeoutMillis);
        if (!completed) {
            result.hits().addError(ErrorMessage.createTimeout((String)("Timed out after waiting " + timeoutMillis + " ms for responses")));
        }
        response.processReplies();
        if (fieldName != null) {
            this.handleFieldFiltering(response, result, fieldName, contentType, headersOnly);
        } else {
            response.addHitsToResult(result, populateHitFields);
        }
    }

    private void sendDocumentGetMessages(List<String> documentIds, String fieldSet, SingleSender sender) {
        for (String docIdStr : documentIds) {
            DocumentId docId = new DocumentId(docIdStr);
            GetDocumentMessage getMsg = new GetDocumentMessage(docId, fieldSet);
            sender.send((Message)getMsg);
            if (!log.isLoggable((Level)LogLevel.DEBUG)) continue;
            log.log((Level)LogLevel.DEBUG, "Sent GetDocumentMessage for " + docId.toString());
        }
    }

    boolean verifyBackendDocumentHitsOnly(Result result) {
        if (result.hits().size() != 0) {
            log.log((Level)LogLevel.DEBUG, "Result had hits after being sent down");
            for (int i = 0; i < result.hits().size(); ++i) {
                if (result.hits().get(i) instanceof DocumentHit) continue;
                log.log(LogLevel.WARNING, "Got hit from backend searcher which was not a com.yahoo.storage.searcher.DocumentHit instance: " + result.hits().get(i).getClass().getName());
                return false;
            }
        }
        return true;
    }

    public Result search(Query query, Execution execution) {
        List<String> documentIds;
        Result result = execution.search(query);
        try {
            documentIds = this.getDocumentIds(query);
        }
        catch (Exception e) {
            GetSearcher.setOutputFormat(query, result);
            result.hits().addError(ErrorMessage.createIllegalQuery((String)(e.getClass().getName() + ": " + e.getMessage())));
            return result;
        }
        if (documentIds.isEmpty()) {
            return result;
        }
        if (!this.verifyBackendDocumentHitsOnly(result)) {
            result = new Result(query);
            GetSearcher.setOutputFormat(query, result);
            result.hits().addError(ErrorMessage.createInternalServerError((String)"A backend searcher to com.yahoo.storage.searcher.GetSearcher returned a hit that was not an instance of com.yahoo.storage.searcher.DocumentHit. Only DocumentHit instances are supported in the backend hit result set when doing queries that contain document identifier sets recognised by the Get Searcher."));
            return result;
        }
        GetSearcher.setOutputFormat(query, result);
        try {
            this.doGetDocuments(query, result, documentIds);
            query.setHits(result.hits().size());
        }
        catch (IllegalArgumentException e) {
            result.hits().addError(ErrorMessage.createIllegalQuery((String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        catch (Exception e) {
            result.hits().addError(ErrorMessage.createUnspecifiedError((String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return result;
    }

    static void setOutputFormat(Query query, Result result) {
        if (GetSearcher.getRequestProperty(formatShortcut, "", query).equals("JsonRenderer")) {
            return;
        }
        if (GetSearcher.getRequestProperty(format, "", query).equals("JsonRenderer")) {
            return;
        }
        if (GetSearcher.getRequestProperty(formatShortcut, "", query).equals("json")) {
            return;
        }
        if (GetSearcher.getRequestProperty(format, "", query).equals("json")) {
            return;
        }
        result.getTemplating().setTemplates((UserTemplate)new DocumentXMLTemplate());
    }

    private static String getRequestProperty(CompoundName propertyName, String defaultValue, Query query) {
        String propertyValue = query.getHttpRequest().getProperty(propertyName.toString());
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    private class GetResponse
    implements SharedSender.ResultCallback {
        private Map<String, Integer> ordering;
        private List<DocumentHit> documentHits = new ArrayList<DocumentHit>();
        private List<DefaultErrorHit> errorHits = new ArrayList<DefaultErrorHit>();
        private List<Reply> replies = new ArrayList<Reply>();
        private final SharedSender.Pending pendingNumber = new SharedSender.Pending();

        public GetResponse(List<String> documentIds) {
            this.ordering = new HashMap<String, Integer>(documentIds.size());
            for (int i = 0; i < documentIds.size(); ++i) {
                this.ordering.put(documentIds.get(i), i);
            }
        }

        public boolean isAborted() {
            return false;
        }

        private String stackTraceFromException(Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter ps = new PrintWriter(sw);
            e.printStackTrace(ps);
            ps.flush();
            return sw.toString();
        }

        public boolean handleReply(Reply reply) {
            if (reply.getTrace().getLevel() > 0 && log.isLoggable((Level)LogLevel.DEBUG)) {
                String str = reply.getTrace().toString();
                log.log((Level)LogLevel.DEBUG, str);
            }
            this.replies.add(reply);
            return true;
        }

        public SharedSender.Pending getPending() {
            return this.pendingNumber;
        }

        private void processReplies() {
            for (Reply reply : this.replies) {
                this.processReply(reply);
            }
        }

        private void processReply(Reply reply) {
            if (!reply.hasErrors()) {
                try {
                    this.addDocumentHit(reply);
                }
                catch (Exception e) {
                    String msg = "Got exception of type " + e.getClass().getName() + " during document deserialization: " + e.getMessage();
                    this.errorHits.add(new DefaultErrorHit("GetSearcher", ErrorMessage.createInternalServerError((String)msg)));
                    log.log((Level)LogLevel.DEBUG, "Got exception during document deserialization: " + this.stackTraceFromException(e));
                }
            } else {
                this.errorHits.add(new DefaultErrorHit("GetSearcher", (ErrorMessage)new MessageBusErrorMessage(reply.getError(0).getCode(), 0, reply.getError(0).getMessage())));
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "Received error reply with message " + reply.getError(0).getMessage());
                }
            }
        }

        private void addDocumentHit(Reply reply) {
            Document doc = ((GetDocumentReply)reply).getDocument();
            GetDocumentMessage msg = (GetDocumentMessage)reply.getMessage();
            Integer index = this.ordering.get(msg.getDocumentId().toString());
            if (index == null) {
                throw new IllegalStateException("Received GetDocumentReply for unknown document: " + doc.getId().toString());
            }
            if (doc != null) {
                this.documentHits.add(new DocumentHit(doc, index));
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "Received GetDocumentReply for " + doc.getId().toString());
                }
            } else if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Received empty (not found) GetDocumentReply for " + msg.getDocumentId().toString());
            }
        }

        public void addHitsToResult(Result result, boolean populateHitFields) {
            for (DefaultErrorHit defaultErrorHit : this.errorHits) {
                result.hits().add((Hit)defaultErrorHit);
            }
            Collections.sort(this.documentHits, new IndexComparator());
            for (DocumentHit documentHit : this.documentHits) {
                if (populateHitFields) {
                    documentHit.populateHitFields();
                }
                result.hits().add((Hit)documentHit);
            }
            result.setTotalHitCount((long)this.documentHits.size());
        }

        public List<DocumentHit> getDocumentHits() {
            return this.documentHits;
        }

        public List<DefaultErrorHit> getErrorHits() {
            return this.errorHits;
        }

        private class IndexComparator
        implements Comparator<DocumentHit> {
            private IndexComparator() {
            }

            @Override
            public int compare(DocumentHit o1, DocumentHit o2) {
                return o1.getIndex() - o2.getIndex();
            }
        }
    }
}

