/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.TryExecutor;
import org.eclipse.jetty.util.thread.strategy.EatWhatYouKill;

public class HTTP2Connection
extends AbstractConnection
implements WriteFlusher.Listener {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private static final boolean PEC_MODE = Boolean.getBoolean("org.eclipse.jetty.http2.PEC_MODE");
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final HTTP2Producer producer = new HTTP2Producer();
    private final AtomicLong bytesIn = new AtomicLong();
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;
    private final ExecutionStrategy strategy;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
        if (PEC_MODE) {
            executor = new TryExecutor.NoTryExecutor(executor);
        }
        this.strategy = new EatWhatYouKill(this.producer, executor);
        LifeCycle.start(this.strategy);
        parser.init(x$0 -> new ParserListener((Parser.Listener)x$0));
    }

    @Override
    public long getMessagesIn() {
        HTTP2Session session = (HTTP2Session)this.getSession();
        return session.getStreamsOpened();
    }

    @Override
    public long getMessagesOut() {
        HTTP2Session session = (HTTP2Session)this.getSession();
        return session.getStreamsClosed();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this.session.getBytesWritten();
    }

    public ISession getSession() {
        return this.session;
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void setInputBuffer(ByteBuffer buffer) {
        this.producer.setInputBuffer(buffer);
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", this);
        }
        super.onOpen();
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", this);
        }
        super.onClose();
        LifeCycle.stop(this.strategy);
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", this);
        }
        this.produce();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not read from " + endPoint, x);
            }
            return -1;
        }
    }

    @Override
    public boolean onIdleExpired() {
        boolean close;
        boolean idle = this.isFillInterested();
        if (idle && (close = this.session.onIdleTimeout())) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    protected void offerTask(Runnable task, boolean dispatch) {
        this.offerTask(task);
        if (dispatch) {
            this.dispatch();
        } else {
            this.produce();
        }
    }

    protected void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 produce {} ", this);
        }
        this.strategy.produce();
    }

    protected void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 dispatch {} ", this);
        }
        this.strategy.dispatch();
    }

    @Override
    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerTask(Runnable task) {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            this.tasks.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pollTask() {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            return this.tasks.poll();
        }
    }

    @Override
    public void onFlushed(long bytes) throws IOException {
        this.session.onFlushed(bytes);
    }

    private class NetworkBuffer
    extends RetainableByteBuffer
    implements Callback {
        private NetworkBuffer() {
            super(HTTP2Connection.this.byteBufferPool, HTTP2Connection.this.bufferSize, false);
        }

        private void put(ByteBuffer source2) {
            BufferUtil.append(this.getBuffer(), source2);
        }

        @Override
        public void succeeded() {
            this.completed(null);
        }

        @Override
        public void failed(Throwable failure) {
            this.completed(failure);
        }

        private void completed(Throwable failure) {
            if (this.release() == 0 && LOG.isDebugEnabled()) {
                LOG.debug("Released retained " + this, failure);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private class ParserListener
    extends Parser.Listener.Wrapper {
        private ParserListener(Parser.Listener listener) {
            super(listener);
        }

        @Override
        public void onData(DataFrame frame) {
            NetworkBuffer networkBuffer = HTTP2Connection.this.producer.networkBuffer;
            networkBuffer.retain();
            NetworkBuffer callback = networkBuffer;
            HTTP2Connection.this.session.onData(frame, callback);
        }

        @Override
        public void onConnectionFailure(int error, String reason) {
            HTTP2Connection.this.producer.failed = true;
            super.onConnectionFailure(error, reason);
        }
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        @Override
        public void succeeded() {
            HTTP2Connection.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
            HTTP2Connection.this.onFillInterestedFailed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private final Callback fillableCallback;
        private NetworkBuffer networkBuffer;
        private boolean shutdown;
        private boolean failed;

        protected HTTP2Producer() {
            this.fillableCallback = new FillableCallback();
        }

        private void setInputBuffer(ByteBuffer byteBuffer) {
            this.acquireNetworkBuffer();
            this.networkBuffer.put(byteBuffer);
        }

        @Override
        public Runnable produce() {
            Runnable task = HTTP2Connection.this.pollTask();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", String.valueOf(task));
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested() || this.shutdown || this.failed) {
                return null;
            }
            boolean interested = false;
            this.acquireNetworkBuffer();
            try {
                boolean parse = this.networkBuffer.hasRemaining();
                while (true) {
                    if (parse) {
                        while (this.networkBuffer.hasRemaining()) {
                            HTTP2Connection.this.parser.parse(this.networkBuffer.getBuffer());
                            if (!this.failed) continue;
                            Runnable runnable2 = null;
                            return runnable2;
                        }
                        task = HTTP2Connection.this.pollTask();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dequeued new task {}", task);
                        }
                        if (task != null) {
                            Runnable runnable3 = task;
                            return runnable3;
                        }
                        if (this.networkBuffer.getReferences() > 1) {
                            this.reacquireNetworkBuffer();
                        }
                    }
                    int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.networkBuffer.getBuffer());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Filled {} bytes in {}", filled, this.networkBuffer);
                    }
                    if (filled <= 0) {
                        if (filled == 0) {
                            interested = true;
                            Runnable runnable4 = null;
                            return runnable4;
                        }
                        this.shutdown = true;
                        HTTP2Connection.this.session.onShutdown();
                        Runnable runnable5 = null;
                        return runnable5;
                    }
                    HTTP2Connection.this.bytesIn.addAndGet(filled);
                    parse = true;
                }
            }
            finally {
                this.releaseNetworkBuffer();
                if (interested) {
                    HTTP2Connection.this.getEndPoint().fillInterested(this.fillableCallback);
                }
            }
        }

        private void acquireNetworkBuffer() {
            if (this.networkBuffer == null) {
                this.networkBuffer = new NetworkBuffer();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Acquired {}", this.networkBuffer);
                }
            }
        }

        private void reacquireNetworkBuffer() {
            NetworkBuffer currentBuffer = this.networkBuffer;
            if (currentBuffer == null) {
                throw new IllegalStateException();
            }
            if (currentBuffer.hasRemaining()) {
                throw new IllegalStateException();
            }
            currentBuffer.release();
            this.networkBuffer = new NetworkBuffer();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reacquired {}<-{}", currentBuffer, this.networkBuffer);
            }
        }

        private void releaseNetworkBuffer() {
            NetworkBuffer currentBuffer = this.networkBuffer;
            if (currentBuffer == null) {
                throw new IllegalStateException();
            }
            if (currentBuffer.hasRemaining() && !this.shutdown && !this.failed) {
                throw new IllegalStateException();
            }
            currentBuffer.release();
            this.networkBuffer = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Released {}", currentBuffer);
            }
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }
}

