/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Adapter {
    private static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final DeferredContentProvider.Chunk EOF = new DeferredContentProvider.Chunk(BufferUtil.EMPTY_BUFFER, Callback.NOOP);
    private final Object lock = this;
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final Queue<DeferredContentProvider.Chunk> chunks = new ArrayDeque<DeferredContentProvider.Chunk>();
    private Response response;
    private Result result;
    private Throwable failure;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHeaders(Response response) {
        Object object = this.lock;
        synchronized (object) {
            this.response = response;
            this.responseLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContent(Response response, ByteBuffer content, Callback callback) {
        boolean closed;
        if (content.remaining() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped empty content {}", content);
            }
            callback.succeeded();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            closed = this.closed;
            if (!closed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queueing content {}", content);
                }
                this.chunks.add(new DeferredContentProvider.Chunk(content, callback));
                this.lock.notifyAll();
            }
        }
        if (closed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream closed, ignored content {}", content);
            }
            callback.failed(new AsynchronousCloseException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Response response) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.chunks.add(EOF);
            }
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End of content", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Response response, Throwable failure) {
        List<Callback> callbacks;
        Object object = this.lock;
        synchronized (object) {
            if (this.failure != null) {
                return;
            }
            this.failure = failure;
            callbacks = this.drain();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content failure", failure);
        }
        callbacks.forEach(callback -> callback.failed(failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(Result result) {
        Throwable failure = result.getFailure();
        List<Object> callbacks = Collections.emptyList();
        Object object = this.lock;
        synchronized (object) {
            this.result = result;
            if (result.isFailed() && this.failure == null) {
                this.failure = failure;
                callbacks = this.drain();
            }
            this.responseLatch.countDown();
            this.resultLatch.countDown();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            if (failure == null) {
                LOG.debug("Result success", new Object[0]);
            } else {
                LOG.debug("Result failure", failure);
            }
        }
        callbacks.forEach(callback -> callback.failed(failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout2, unit);
        if (expired) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                throw new ExecutionException(this.failure);
            }
            return this.response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result await(long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout2, unit);
        if (expired) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    public InputStream getInputStream() {
        Input result = new Input();
        if (this.stream.compareAndSet(null, result)) {
            return result;
        }
        return IO.getClosedStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Callback> drain() {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        Object object = this.lock;
        synchronized (object) {
            DeferredContentProvider.Chunk chunk;
            while ((chunk = this.chunks.peek()) != null && chunk != EOF) {
                callbacks.add(chunk.callback);
                this.chunks.poll();
            }
        }
        return callbacks;
    }

    private class Input
    extends InputStream {
        private Input() {
        }

        @Override
        public int read() throws IOException {
            byte[] tmp = new byte[1];
            int read = this.read(tmp);
            if (read < 0) {
                return read;
            }
            return tmp[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            try {
                int result;
                Callback callback = null;
                Object object = InputStreamResponseListener.this.lock;
                synchronized (object) {
                    DeferredContentProvider.Chunk chunk;
                    while (true) {
                        if ((chunk = (DeferredContentProvider.Chunk)InputStreamResponseListener.this.chunks.peek()) == EOF) {
                            return -1;
                        }
                        if (chunk != null) break;
                        if (InputStreamResponseListener.this.failure != null) {
                            throw this.toIOException(InputStreamResponseListener.this.failure);
                        }
                        if (InputStreamResponseListener.this.closed) {
                            throw new AsynchronousCloseException();
                        }
                        InputStreamResponseListener.this.lock.wait();
                    }
                    ByteBuffer buffer = chunk.buffer;
                    result = Math.min(buffer.remaining(), length);
                    buffer.get(b, offset, result);
                    if (!buffer.hasRemaining()) {
                        callback = chunk.callback;
                        InputStreamResponseListener.this.chunks.poll();
                    }
                }
                if (callback != null) {
                    callback.succeeded();
                }
                return result;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        private IOException toIOException(Throwable failure) {
            if (failure instanceof IOException) {
                return (IOException)failure;
            }
            return new IOException(failure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List callbacks;
            Object object = InputStreamResponseListener.this.lock;
            synchronized (object) {
                if (InputStreamResponseListener.this.closed) {
                    return;
                }
                InputStreamResponseListener.this.closed = true;
                callbacks = InputStreamResponseListener.this.drain();
                InputStreamResponseListener.this.lock.notifyAll();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream close", new Object[0]);
            }
            AsynchronousCloseException failure = new AsynchronousCloseException();
            callbacks.forEach(callback -> callback.failed(failure));
            super.close();
        }
    }
}

