/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.Cluster;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.feed.client.HttpRequest;
import ai.vespa.feed.client.HttpResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class JettyCluster
implements Cluster {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    JettyCluster(FeedClientBuilder builder) {
        for (URI endpoint : builder.endpoints) {
            for (int i = 0; i < builder.connectionsPerEndpoint; ++i) {
                this.endpoints.add(new Endpoint(JettyCluster.createJettyHttpClient(builder), endpoint));
            }
        }
    }

    private static HttpClient createJettyHttpClient(FeedClientBuilder builder) {
        try {
            SslContextFactory.Client clientSslCtxFactory = new SslContextFactory.Client();
            clientSslCtxFactory.setSslContext(builder.constructSslContext());
            clientSslCtxFactory.setHostnameVerifier(builder.hostnameVerifier);
            HTTP2Client wrapped = new HTTP2Client();
            wrapped.setMaxConcurrentPushedStreams(builder.maxStreamsPerConnection);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(wrapped);
            HttpClient client = new HttpClient(transport, clientSslCtxFactory);
            client.setUserAgentField(new HttpField("User-Agent", String.format("vespa-feed-client/%s", "7.420.21")));
            client.setFollowRedirects(false);
            client.setMaxRequestsQueuedPerDestination(builder.maxStreamsPerConnection);
            client.setMaxConnectionsPerDestination(1);
            client.start();
            return client;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void dispatch(HttpRequest request, final CompletableFuture<HttpResponse> vessel) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (this.endpoints.get(i).inflight.get() >= min) continue;
            index = i;
            min = this.endpoints.get(i).inflight.get();
        }
        Endpoint endpoint = this.endpoints.get(index);
        endpoint.inflight.incrementAndGet();
        try {
            Request jettyRequest = endpoint.client.newRequest(endpoint.uri.resolve(request.path())).method(request.method()).timeout(5L, TimeUnit.MINUTES).content(request.body() == null ? null : new BytesContentProvider("application/json", (byte[][])new byte[][]{request.body()}));
            request.headers().forEach((name, value) -> jettyRequest.header((String)name, (String)value.get()));
            jettyRequest.send(new BufferingResponseListener(){

                @Override
                public void onComplete(Result result) {
                    if (result.isSucceeded()) {
                        vessel.complete(HttpResponse.of(result.getResponse().getStatus(), this.getContent()));
                    } else {
                        vessel.completeExceptionally(result.getFailure());
                    }
                }
            });
        }
        catch (Throwable thrown) {
            vessel.completeExceptionally(thrown);
        }
        vessel.whenComplete((__, ___) -> endpoint.inflight.decrementAndGet());
    }

    @Override
    public void close() {
        Throwable thrown = null;
        for (Endpoint endpoint : this.endpoints) {
            try {
                endpoint.client.stop();
            }
            catch (Throwable t) {
                if (thrown == null) {
                    thrown = t;
                    continue;
                }
                thrown.addSuppressed(t);
            }
        }
        if (thrown != null) {
            throw new RuntimeException(thrown);
        }
    }

    private static class Endpoint {
        private final HttpClient client;
        private final AtomicInteger inflight = new AtomicInteger(0);
        private final URI uri;

        private Endpoint(HttpClient client, URI uri) {
            this.client = client;
            this.uri = uri;
        }
    }
}

