/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.GracePeriodCircuitBreaker;
import ai.vespa.feed.client.HttpFeedClient;
import ai.vespa.feed.client.SslContextBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class FeedClientBuilder {
    static final FeedClient.RetryStrategy defaultRetryStrategy = new FeedClient.RetryStrategy(){};
    final List<URI> endpoints;
    final Map<String, Supplier<String>> requestHeaders = new HashMap<String, Supplier<String>>();
    SSLContext sslContext;
    HostnameVerifier hostnameVerifier;
    int connectionsPerEndpoint = 4;
    int maxStreamsPerConnection = 128;
    FeedClient.RetryStrategy retryStrategy = defaultRetryStrategy;
    FeedClient.CircuitBreaker circuitBreaker = new GracePeriodCircuitBreaker(Duration.ofSeconds(1L), Duration.ofMinutes(10L));
    Path certificateFile;
    Path privateKeyFile;
    Path caCertificatesFile;
    Collection<X509Certificate> certificate;
    PrivateKey privateKey;
    Collection<X509Certificate> caCertificates;

    public static FeedClientBuilder create(URI endpoint) {
        return new FeedClientBuilder(Collections.singletonList(endpoint));
    }

    public static FeedClientBuilder create(List<URI> endpoints) {
        return new FeedClientBuilder(endpoints);
    }

    private FeedClientBuilder(List<URI> endpoints) {
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("At least one endpoint must be provided");
        }
        for (URI endpoint : endpoints) {
            Objects.requireNonNull(endpoint.getHost());
        }
        this.endpoints = new ArrayList<URI>(endpoints);
    }

    public FeedClientBuilder setConnectionsPerEndpoint(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max connections must be at least 1, but was " + max);
        }
        this.connectionsPerEndpoint = max;
        return this;
    }

    public FeedClientBuilder setMaxStreamPerConnection(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max streams per connection must be at least 1, but was " + max);
        }
        this.maxStreamsPerConnection = max;
        return this;
    }

    public FeedClientBuilder setSslContext(SSLContext context) {
        this.sslContext = Objects.requireNonNull(context);
        return this;
    }

    public FeedClientBuilder setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = Objects.requireNonNull(verifier);
        return this;
    }

    public FeedClientBuilder addRequestHeader(String name, String value) {
        return this.addRequestHeader(name, () -> Objects.requireNonNull(value));
    }

    public FeedClientBuilder addRequestHeader(String name, Supplier<String> valueSupplier) {
        this.requestHeaders.put(Objects.requireNonNull(name), Objects.requireNonNull(valueSupplier));
        return this;
    }

    public FeedClientBuilder setRetryStrategy(FeedClient.RetryStrategy strategy) {
        this.retryStrategy = Objects.requireNonNull(strategy);
        return this;
    }

    public FeedClientBuilder setCircuitBreaker(FeedClient.CircuitBreaker breaker) {
        this.circuitBreaker = Objects.requireNonNull(breaker);
        return this;
    }

    public FeedClientBuilder setCertificate(Path certificatePemFile, Path privateKeyPemFile) {
        this.certificateFile = certificatePemFile;
        this.privateKeyFile = privateKeyPemFile;
        return this;
    }

    public FeedClientBuilder setCertificate(Collection<X509Certificate> certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        return this;
    }

    public FeedClientBuilder setCertificate(X509Certificate certificate, PrivateKey privateKey) {
        return this.setCertificate(Collections.singletonList(certificate), privateKey);
    }

    public FeedClientBuilder setCaCertificatesFile(Path caCertificatesFile) {
        this.caCertificatesFile = caCertificatesFile;
        return this;
    }

    public FeedClientBuilder setCaCertificates(Collection<X509Certificate> caCertificates) {
        this.caCertificates = caCertificates;
        return this;
    }

    public FeedClient build() {
        try {
            this.validateConfiguration();
            return new HttpFeedClient(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SSLContext constructSslContext() throws IOException {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        SslContextBuilder sslContextBuilder = new SslContextBuilder();
        if (this.certificateFile != null && this.privateKeyFile != null) {
            sslContextBuilder.withCertificateAndKey(this.certificateFile, this.privateKeyFile);
        } else if (this.certificate != null && this.privateKey != null) {
            sslContextBuilder.withCertificateAndKey(this.certificate, this.privateKey);
        }
        if (this.caCertificatesFile != null) {
            sslContextBuilder.withCaCertificates(this.caCertificatesFile);
        } else if (this.caCertificates != null) {
            sslContextBuilder.withCaCertificates(this.caCertificates);
        }
        return sslContextBuilder.build();
    }

    private void validateConfiguration() {
        if (this.sslContext != null && (this.certificateFile != null || this.caCertificatesFile != null || this.privateKeyFile != null || this.certificate != null || this.caCertificates != null || this.privateKey != null)) {
            throw new IllegalArgumentException("Cannot set both SSLContext and certificate / CA certificates");
        }
        if (this.certificate != null && this.certificateFile != null) {
            throw new IllegalArgumentException("Cannot set both certificate directly and as file");
        }
        if (this.privateKey != null && this.privateKeyFile != null) {
            throw new IllegalArgumentException("Cannot set both private key directly and as file");
        }
        if (this.caCertificates != null && this.caCertificatesFile != null) {
            throw new IllegalArgumentException("Cannot set both CA certificates directly and as file");
        }
        if (this.certificate != null && this.certificate.isEmpty()) {
            throw new IllegalArgumentException("Certificate cannot be empty");
        }
        if (this.caCertificates != null && this.caCertificates.isEmpty()) {
            throw new IllegalArgumentException("CA certificates cannot be empty");
        }
    }
}

